% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-modifiedFunctions.R
\name{.cc_round_occTest}
\alias{.cc_round_occTest}
\title{Flag records with regular pattern interval}
\usage{
.cc_round_occTest(
  x,
  lon = "decimallongitude",
  lat = "decimallatitude",
  ds = "dataset",
  T1 = 7,
  reg_out_thresh = 2,
  reg_dist_min = 0.1,
  reg_dist_max = 2,
  min_unique_ds_size = 4,
  graphs = FALSE,
  test = "both",
  value = "flagged",
  verbose = TRUE
)
}
\arguments{
\item{x}{Data.frame of species occurrences}

\item{lon}{character. Column name in x with decimal longitude values}

\item{lat}{character. Column name in x with decimal latitude values}

\item{ds}{character. Column name in x with dataset name of the record}

\item{T1}{numeric. Defaults to 7}

\item{reg_out_thresh}{numeric. Defaults to 7}

\item{reg_dist_min}{numeric. Defaults to 7}

\item{reg_dist_max}{numeric. Defaults to 7}

\item{min_unique_ds_size}{numeric. Defaults to 7}

\item{graphs}{logical. Defaults to FALSE.}

\item{test}{character. Defaults to 'both'}

\item{value}{character. Defaults to flagged}

\item{verbose}{logical. Defaults to TRUE.}
}
\value{
a clean data.frame
}
\description{
own version of coordinate cleaner cc_round
}
\seealso{
\link[CoordinateCleaner]{CoordinateCleaner-package}
}
\author{
A Zizka (original author) Josep M Serra-Diaz (adapted from CoordinateCleaner)
}
