% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/studyTaxonList.R
\name{studyTaxonList}
\alias{studyTaxonList}
\title{Study Taxon List}
\usage{
studyTaxonList(x = NULL, datasources = "GBIF Backbone Taxonomy")
}
\arguments{
\item{x}{A phylogeny of class 'phylo' or a vector of class 'character'
containing the names of taxa of interest}

\item{datasources}{A vector of taxonomic data sources implemented in
\code{\link{gnr_resolve}}. You can see the list using
\code{taxize::gnr_datasources()}.}
}
\value{
An object of class \code{\link{occCiteData}} containing the type
of inquiry the user has made --a phylogeny or a vector of names-- and a
data frame containing input taxa names, the closest match according to
\code{\link{gnr_resolve}}, and a list of taxonomic data sources that
contain the matching name.
}
\description{
Takes input phylogenies or vectors of taxon names, checks
against taxonomic database, returns vector of cleaned taxonomic names
(using \code{\link{taxonRectification}}) for use in spocc queries, as
well as warnings if there are invalid names.
}
\examples{
## Inputting a vector of taxon names
studyTaxonList(
  x = c(
    "Buteo buteo",
    "Buteo buteo hartedi",
    "Buteo japonicus"
  ),
  datasources = c("National Center for Biotechnology Information")
)

## Inputting a phylogeny
phylogeny <- ape::read.nexus(
  system.file("extdata/Fish_12Tax_time_calibrated.tre",
    package = "occCite"
  )
)
phylogeny <- ape::extract.clade(phylogeny, 18)
studyTaxonList(
  x = phylogeny,
  datasources = c("GBIF Backbone Taxonomy")
)
}
