% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oblicubesGrob.R
\name{oblicubesGrob}
\alias{oblicubesGrob}
\alias{grid.oblicubes}
\title{Render 2D/3D cubes via an oblique projection}
\usage{
oblicubesGrob(
  x,
  y = NULL,
  z = NULL,
  ...,
  fill = NULL,
  light = darken_face,
  scale = 0.5,
  angle = 45,
  xo = NULL,
  yo = NULL,
  width = NULL,
  default.units = "snpc",
  name = NULL,
  gp = gpar(),
  vp = NULL
)

grid.oblicubes(
  x,
  y = NULL,
  z = NULL,
  ...,
  fill = NULL,
  light = darken_face,
  scale = 0.5,
  angle = 45,
  xo = NULL,
  yo = NULL,
  width = NULL,
  default.units = "snpc",
  name = NULL,
  gp = gpar(),
  vp = NULL
)
}
\arguments{
\item{x}{Integer vector of x coordinates (if necessary will be rounded to integers).
May be a \code{data.frame} of x,y,z coordinates (and maybe fill color).}

\item{y}{Integer vector of y coordinates (if necessary will be rounded to integers).
If \code{NULL} and \code{x} is a data frame with a \code{y} column then we use that instead.}

\item{z}{Integer vector of z coordinates (if necessary will be rounded to integers).
If \code{NULL} and \code{x} is a data frame with a \code{z} column then we use that instead.}

\item{...}{Passed to \code{\link[grid:gpar]{grid::gpar()}}.  Will override any values set in \code{gp}.}

\item{fill}{Fill color(s) for the cubes.
If \code{NULL} and \code{x} is a data frame with a \code{fill} or \code{col} column then we use that column;
if no such column but \code{gp} has a \code{fill} value we use that;
otherwise we fall back to "grey90".}

\item{light}{If \code{FALSE} don't perform a "light" effect.
Otherwise a function that takes two arguments:
the first \code{face} of the cube/cuboid face
(one of "top", "west", "east", "south", "north").
the second \code{col} of the fill color.
By default we use \code{\link[=darken_face]{darken_face()}}.}

\item{scale}{Oblique projection foreshortening factor.
0.5 corresponds to the \dQuote{cabinet projection}.
1.0 corresponds to the \dQuote{cavalier projection}.
0.0 corresponds to a \dQuote{primary view orthographic projection}.}

\item{angle}{Oblique projection angle.}

\item{xo, yo}{The origin of the oblique projection coordinate system in grid units.
The default is to try to guess a \dQuote{good} value.}

\item{width}{Width of the cube's (non-foreshortened) sides.
The default will be to try to guess a \dQuote{good} value.}

\item{default.units}{Default units for the \code{xo}, \code{yo}, and \code{width} arguments.}

\item{name}{A character identifier (for grid).}

\item{gp}{A \sQuote{grid} gpar object.  See \code{\link[grid:gpar]{grid::gpar()}}.
Will be merged with the values in \code{...} and the value of \code{fill}.}

\item{vp}{A \sQuote{grid} viewport object.  See \code{\link[grid:viewport]{grid::viewport()}}.}
}
\value{
A grid grob.  As a side effect \code{grid.oblicubes()} also draws to the active graphics device.
}
\description{
\code{oblicubesGrob()} / \code{grid.oblicubes()} renders cubes using a 3D oblique projection.
\code{oblicubesGrob()} returns a grid grob object while
\code{grid.oblicubes()} also draws the grob to the graphic device.
As a special case may also render a 2D primary view orthographic projection.
}
\examples{
if (require("grid")) {
  # we support arbitrary oblique projection angles
  mat <- matrix(c(1, 2, 1, 2, 3, 2, 1, 2, 1), nrow = 3, ncol = 3, byrow = TRUE)
  coords <- xyz_heightmap(mat, col = c("red", "yellow", "green"))

  angles <- c(135, 90, 45, 180, 45, 0, -135, -90, -45)
  scales <- c(0.5, 0.5, 0.5, 0.5, 0.0, 0.5, 0.5, 0.5, 0.5)
  vp_x <- rep(1:3/3 - 1/6, 3)
  vp_y <- rep(3:1/3 - 1/6, each = 3)
  grid.newpage()
  for (i in 1:9) {
      pushViewport(viewport(x=vp_x[i], y=vp_y[i], width=1/3, height=1/3))
      grid.rect(gp = gpar(lty = "dashed"))
      grid.oblicubes(coords, width = 0.15, xo = 0.25, yo = 0.15,
                     angle = angles[i], scale = scales[i],
                     gp = gpar(lwd=4))
      if(i != 5)
          grid.text(paste("angle =", angles[i]), y=0.92, gp = gpar(cex = 1.2))
      else
          grid.text(paste("scale = 0"), y=0.92, gp = gpar(cex = 1.2))
      popViewport()
  }
}
# volcano example
mat <- datasets::volcano
mat <- 0.3 * (mat - min(mat)) + 1.0
coords <- xyz_heightmap(mat, col = grDevices::terrain.colors)
grid::grid.newpage()
grid.oblicubes(coords)
}
