% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/siblings.R
\name{siblings}
\alias{siblings}
\alias{siblings.rtree}
\title{Siblings of a node}
\usage{
siblings(.node, .tree, include_node = FALSE)

\method{siblings}{rtree}(.node, .tree, include_node = FALSE)
}
\arguments{
\item{.node}{node or character. The node or label of the node considered.}

\item{.tree}{A tree.}

\item{include_node}{logical. If \code{FALSE} (the default), the node \code{.node} is 
not included to the list of siblings.}
}
\value{
A (possibly empty) list of nodes.
}
\description{
The function \code{siblings} returns the siblings 
of a node in a given tree.
}
\examples{
## Rooted tree
(tr0 = c_("Bob", "Carl", "Daniel"))
(tr1 = c_("Bill", "Caroline", "Dimitri", "Enoc"))
(tr2 = r_("Alice", s = list(tr0, tr1)))
siblings("Bob", tr2)

## Unrooted tree
(tr3 = r_(s = list(tr2, c_("Grand-Mother", "Father", "Son"))))
siblings("Alice", tr3) # note that in 'tr3', Alice and Grand-Mother are not siblings

}
