% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.list.tree.R
\name{as.list.rtree}
\alias{as.list.rtree}
\title{Conversion of a tree to a list}
\usage{
\method{as.list}{rtree}(x, recursively = FALSE, ...)
}
\arguments{
\item{x}{A tree.}

\item{recursively}{logical. See below.}

\item{...}{Additional arguments (not used).}
}
\value{
A list. 
If \code{recursively=FALSE}, this list is made up of the subtrees of \code{x}. 
If \code{recursively=TRUE}, these subtrees are themselves recursively 
converted to a list.
}
\description{
This function converts a tree to a list.
}
\examples{
(tr0 = c_("Bob", "Carl", "Daniel"))
(tr1 = c_("Bill", "Caroline", "Dimitri", "Enoc"))
(tr2 = r_("Alice", s = list(tr0, tr1)))
as.list(tr2)
as.list(tr2, rec = TRUE)

## Unrooted tree
(tr3 = r_(s = list(tr2, c_("Grand-Mother", "Father", "Son"))))
as.list(tr3)
as.list(tr3, rec = TRUE)

}
