context("Test 'children()' function")

test_that("function 'children()' works properly", {
  
  expect_identical(list(), children("TOTO", empty_tree()))
  
  tr0 = c_("Bob", "Carl", "Daniel")
  expect_identical(list(r_("Carl")), children("Bob", tr0))
  expect_identical(list(r_("Daniel")), children("Carl", tr0))
  expect_identical(list(), children("Daniel", tr0))
  expect_identical(list(), children("TOTO", tr0))
  
  tr1 = r_("Dimitri", s = list(c_("Enoc"), c_("Ferdinand")))
  expect_identical(list(r_("Enoc"), r_("Ferdinand")), children("Dimitri", tr1))
  expect_identical(list(), children("Enoc", tr1))
  expect_identical(list(), children("Ferdinand", tr1))
  expect_identical(list(), children("TOTO", tr1))
  
  tr1 = r_("Caroline", s = list(tr1))
  expect_identical(list(r_("Dimitri")), children("Caroline", tr1))
  expect_identical(list(r_("Enoc"), r_("Ferdinand")), children("Dimitri", tr1))
  expect_identical(list(), children("Enoc", tr1))
  expect_identical(list(), children("Ferdinand", tr1))
  expect_identical(list(), children("TOTO", tr1))
  
  tr1 = r_("Bill", s = list(tr1))
  expect_identical(list(r_("Caroline")), children("Bill", tr1))
  expect_identical(list(r_("Dimitri")), children("Caroline", tr1))
  expect_identical(list(r_("Enoc"), r_("Ferdinand")), children("Dimitri", tr1))
  expect_identical(list(), children("Enoc", tr1))
  expect_identical(list(), children("Ferdinand", tr1))
  expect_identical(list(), children("TOTO", tr1))
  
  tr2 = r_("Alice", s = list(tr0, tr1))
  expect_identical(list(r_("Bob"), r_("Bill")), children("Alice", tr2))
  expect_identical(list(r_("Carl")), children("Bob", tr2))
  expect_identical(list(r_("Daniel")), children("Carl", tr2))
  expect_identical(list(), children("Daniel", tr2))
  expect_identical(list(r_("Caroline")), children("Bill", tr2))
  expect_identical(list(r_("Dimitri")), children("Caroline", tr2))
  expect_identical(list(r_("Enoc"), r_("Ferdinand")), children("Dimitri", tr2))
  expect_identical(list(), children("Enoc", tr2))
  expect_identical(list(), children("Ferdinand", tr2))
  expect_identical(list(), children("TOTO", tr2))
  
  ## Unrooted tree
  tr3 = r_(s = list(tr2, c_("Grand-Mother", "Father", "Son")))
  expect_identical(list(r_("Bob"), r_("Bill")), children("Alice", tr3))
  expect_identical(list(r_("Carl")), children("Bob", tr3))
  expect_identical(list(r_("Daniel")), children("Carl", tr3))
  expect_identical(list(), children("Daniel", tr3))
  expect_identical(list(r_("Caroline")), children("Bill", tr3))
  expect_identical(list(r_("Dimitri")), children("Caroline", tr3))
  expect_identical(list(r_("Enoc"), r_("Ferdinand")), children("Dimitri", tr3))
  expect_identical(list(), children("Enoc", tr3))
  expect_identical(list(), children("Ferdinand", tr3))
  expect_identical(list(r_("Father")), children("Grand-Mother", tr3))
  expect_identical(list(r_("Son")), children("Father", tr3))
  expect_identical(list(), children("Son", tr3))
  expect_identical(list(), children("TOTO", tr3))
  
})
