% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nzffdr_taxon_threat.R
\name{nzffdr_taxon_threat}
\alias{nzffdr_taxon_threat}
\title{Add taxonomic and threat status data}
\usage{
nzffdr_taxon_threat(fishd)
}
\arguments{
\item{fishd}{A dataframe imported from the NZFFD using \code{nzffd_import}}
}
\value{
An NZFFD dataframe, with 12 additional columns.
}
\description{
Adds additional common and scientific names, and threat classification status
information.
}
\details{
Adds additional taxonomic data ("commonMaoriName", "alternativeNames",
"species", "genus", "family", "order", "class", "phylum") and NZ Threat 
Classification Status information ("category", "status", "taxonomicStatus",
"bioStatus"). See \href{https://nztcs.org.nz/home}{NZTCS} for details
regarding the NZTCS variables.
}
\examples{
nzffdr_taxon_threat(nzffdr::nzffdr_data)
}
