% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dig_tautologies.R
\name{dig_tautologies}
\alias{dig_tautologies}
\title{Find tautologies or "almost tautologies" in a dataset}
\usage{
dig_tautologies(
  x,
  antecedent = everything(),
  consequent = everything(),
  disjoint = var_names(colnames(x)),
  max_length = Inf,
  min_coverage = 0,
  min_support = 0,
  min_confidence = 0,
  contingency_table = FALSE,
  measures = deprecated(),
  t_norm = "goguen",
  max_results = Inf,
  verbose = FALSE,
  threads = 1
)
}
\arguments{
\item{x}{a matrix or data frame with data to search in. The matrix must be
numeric (double) or logical. If \code{x} is a data frame then each column
must be either numeric (double) or logical.}

\item{antecedent}{a tidyselect expression (see
\href{https://tidyselect.r-lib.org/articles/syntax.html}{tidyselect syntax})
specifying the columns to use in the antecedent (left) part of the rules}

\item{consequent}{a tidyselect expression (see
\href{https://tidyselect.r-lib.org/articles/syntax.html}{tidyselect syntax})
specifying the columns to use in the consequent (right) part of the rules}

\item{disjoint}{an atomic vector of size equal to the number of columns of \code{x}
that specifies the groups of predicates: if some elements of the \code{disjoint}
vector are equal, then the corresponding columns of \code{x} will NOT be
present together in a single condition. If \code{x} is prepared with
\code{\link[=partition]{partition()}}, using the \code{\link[=var_names]{var_names()}} function on \code{x}'s column names
is a convenient way to create the \code{disjoint} vector.}

\item{max_length}{The maximum length, i.e., the maximum number of predicates in the
antecedent, of a rule to be generated. If equal to Inf, the maximum length
is limited only by the number of available predicates.}

\item{min_coverage}{the minimum coverage of a rule in the dataset \code{x}.
(See Description for the definition of \emph{coverage}.)}

\item{min_support}{the minimum support of a rule in the dataset \code{x}.
(See Description for the definition of \emph{support}.)}

\item{min_confidence}{the minimum confidence of a rule in the dataset \code{x}.
(See Description for the definition of \emph{confidence}.)}

\item{contingency_table}{a logical value indicating whether to provide a contingency
table for each rule. If \code{TRUE}, the columns \code{pp}, \code{pn}, \code{np}, and \code{nn} are
added to the output table. These columns contain the number of rows satisfying
the antecedent and the consequent, the antecedent but not the consequent,
the consequent but not the antecedent, and neither the antecedent nor the
consequent, respectively.}

\item{measures}{(Deprecated. Search for tautologies using
\code{dig_tautologies(contingency_table = TRUE)} and use the \code{add_interest()}
function on the result to compute additional measures.)
A character vector specifying the additional quality measures to compute.
If \code{NULL}, no additional measures are computed. Possible values are \code{"lift"},
\code{"conviction"}, \code{"added_value"}.
See \url{https://mhahsler.github.io/arules/docs/measures}
for a description of the measures.}

\item{t_norm}{a t-norm used to compute conjunction of weights. It must be one of
\code{"goedel"} (minimum t-norm), \code{"goguen"} (product t-norm), or \code{"lukas"}
(Łukasiewicz t-norm).}

\item{max_results}{the maximum number of generated conditions to execute the
callback function on. If the number of found conditions exceeds
\code{max_results}, the function stops generating new conditions and returns
the results. To avoid long computations during the search, it is recommended
to set \code{max_results} to a reasonable positive value. Setting \code{max_results}
to \code{Inf} will generate all possible conditions.}

\item{verbose}{a logical value indicating whether to print progress messages.}

\item{threads}{the number of threads to use for parallel computation.}
}
\value{
An S3 object which is an instance of \code{associations} and \code{nugget}
classes and which is a tibble with found tautologies in the format equal to
the output of \code{\link[=dig_associations]{dig_associations()}}.
}
\description{
This function finds tautologies in a dataset, i.e., rules of the form
\verb{\{a1 & a2 & ... & an\} => \{c\}} where \code{a1}, \code{a2}, ..., \code{an} are
antecedents and \code{c} is a consequent. The intent of searching for
tautologies is to find rules that are always true, which may be
used for filtering of further generated conditions. The resulting
rules may be used as a basis for the list of \code{excluded} formulae
(see the \code{excluded} argument of \code{\link[=dig]{dig()}}).
}
\details{
The search for tautologies is performed by iteratively
searching for rules with increasing length of the antecedent.
Rules found in previous iterations are used as \code{excluded}
argument in the next iteration.
}
\author{
Michal Burda
}
