% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nsrr_all_files.R
\name{nsrr_all_dataset_files}
\alias{nsrr_all_dataset_files}
\title{NSRR All Dataset files}
\usage{
nsrr_all_dataset_files(dataset, token = nsrr_token(), max_files = Inf)
}
\arguments{
\item{dataset}{a dataset \code{"slug"}, one from
\code{\link{nsrr_datasets}}}

\item{token}{Token for NSRR resources.  Found at
\url{https://sleepdata.org/token}}

\item{max_files}{maximum files to return if not wanting to go through
all folders recursively.}
}
\value{
A \code{data.frame} of the data sets and their endpoints
}
\description{
NSRR All Dataset files
}
\examples{
dataset = "shhs"
df = nsrr_all_dataset_files(dataset, max_files = 10)
testthat::expect_lte(nrow(df), 20)
# keep as donttest - takes a long time
\dontrun{
df = nsrr_all_dataset_files(dataset)
}

}
