\name{sberry}
\alias{sberry}
\docType{data}
\title{
Strawberry Fungal Data 
}
\description{
The strawberry data set is a multivariate response data set that gives the measurements of weight, the percent of Botrytis, percent of other fungal species and the rating of symptoms from Phomopsis leaf blight, for 4 plots of strawberries each treated with one of 4 treatments. Three of the treatments were different chemicals, and one control.
}
\usage{data(sberry)}
\format{
sberry is a data frame with 16 cases (rows) and 6 variables (columns) named replication, weight, bot, fungi, and rating.
}
\details{
A study was conducted in a commercial farm to evaluate the effects of three different fungicides (pesticides) on the control of fruit and foliar diseases of strawberry. A section of a 4-year-old strawberry planting was divided into 16 3-meter long single-row plots, and four treatments were randomly assigned to four plots each: sprayed with Kocide 2000 WG five times; sprayed with Elevate 50 WG plus Switch 62.5 WG four times; sprayed with V-10135 20 WP (experimental fungicide from Valent Corp.) three times; or not sprayed (control). All fruit were harvested and visually evaluated for symptoms of the fungus-caused disease grey mold (also known as Botrytis fruit rot), and symptoms of other fruit rots (caused by various fungal species). Total weight of all harvested fruit was determined. The percent of fruit with symptoms of Botrytis and other species was determined for each plot. Finally, the severity of symptoms on the foliage (leaflets) of Phomopsis leaf blight (another fungal-caused disease) was assessed with a 0-3 ordinal scale, where 0 represents disease free and 3 represents 40\% or more of the foliage covered by lesions. Thirty leaflets were measured in each plot, and the median value of these measurements was determined.
}
\source{
Horst, L.E., Locke, J., Krause, C.R., McMahaon, R.W., Madden, L.V., Hoitink, H.A.J., 2005. Suppression of Botrytis blight of Begonia by Trichoderma hamatum 382 in peat and compost-amended potting mixes. Plant Disease 89, 1195-1200.
}

\examples{
data(sberry)

}
\keyword{datasets}
