% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paket_nph_1-9.R
\name{sample_fun}
\alias{sample_fun}
\title{Draw survival times based on study settings}
\usage{
sample_fun(
  A,
  B,
  r0 = 0.5,
  eventEnd,
  lambdaRecr,
  lambdaCens,
  maxRecrCalendarTime,
  maxCalendar
)
}
\arguments{
\item{A}{An object of class \code{mixpch}, resembling the survival function in treatment group 0}

\item{B}{An object of class \code{mixpch}, resembling the survival function in treatment group 1}

\item{r0}{Allocation ratio to group 0 (must be a number between 0 and 1)}

\item{eventEnd}{Number of events, after which the study stops}

\item{lambdaRecr}{Rate per day for recruiting patients, assuming recruitung follows a Poisson process}

\item{lambdaCens}{Rate per day for random censoring, assuming censoring times are exponential}

\item{maxRecrCalendarTime}{Maximal duration of recruitment in days}

\item{maxCalendar}{Maximal total study duration in days, after which the study stops}
}
\value{
A data frame with each line representing data for one patient and the following columns:
\describe{
\item{\code{group}}{Treatment group}
\item{\code{inclusion}}{Start of observation in terms of calendar time}
\item{\code{y}}{Observed survival/censored time}
\item{\code{yCalendar}}{End of observation in terms of calendar time.}
\item{\code{event}}{logical, \code{TRUE} indicates the observation ended with an event, \code{FALSE} corresponds to censored times}
\item{\code{adminCens}}{logical, \code{True} indicates that the observation is subject to administrative censoring, i.e. the subject was observed until the 
	end of the study without an event.}
\item{\code{cumEvents}}{Cumulative number of events over calendar time of end of observation}
}
The data frame is ordered by \code{yCalendar}
}
\description{
Simulates data for a randomized controlled survival study.
}
\details{
For simulating the data, patients are allocated randomly to either group (unrestricted randomization).
}
\examples{
A <- pop_pchaz(Tint = c(0, 90, 1500),
  lambdaMat1 = matrix(c(0.2, 0.1, 0.4, 0.1), 2, 2) / 365,
 lambdaMat2 = matrix(c(0.5, 0.2, 0.6, 0.2), 2, 2) / 365,
 lambdaProg = matrix(c(0.5, 0.5, 0.4, 0.4), 2, 2) / 365,
 p = c(0.8, 0.2), 
 timezero = FALSE, discrete_approximation = TRUE)
B <- pop_pchaz(Tint = c(0, 90, 1500),
  lambdaMat1 = matrix(c(0.2, 0.1, 0.4, 0.1), 2, 2) / 365,
 lambdaMat2 = matrix(c(0.5, 0.1, 0.6, 0.1), 2, 2) / 365,
 lambdaProg = matrix(c(0.5, 0.5, 0.04, 0.04), 2, 2) / 365,
 p = c(0.8, 0.2), 
 timezero = FALSE, discrete_approximation = TRUE)
plot(A)
plot(B, add = TRUE)
dat <- sample_fun(A, B, r0 = 0.5, eventEnd = 30, lambdaRecr = 0.5,
  lambdaCens = 0.25 / 365, maxRecrCalendarTime = 2 * 365,
  maxCalendar = 4 * 365)
}
\seealso{
\code{\link{rSurv_fun}}, \code{\link{rSurv_conditional_fun}}, \code{\link{sample_conditional_fun}}
}
\author{
Robin Ristl, \email{robin.ristl@meduniwien.ac.at}
}
