% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paket_nph_1-9.R
\name{rSurv_fun}
\alias{rSurv_fun}
\title{Draw random survival times from mixpch object.}
\usage{
rSurv_fun(n, x)
}
\arguments{
\item{n}{Number of random draws}

\item{x}{An object of class \code{mixpch}}
}
\value{
A vector of random survival times.
}
\description{
Draws independent random survival times from \code{mixpch} objects.
}
\details{
The mixpch object stores the survival function up to some time T. For random times equal or larger T, the value T is returned.
}
\examples{
A <- pop_pchaz(Tint = c(0, 90, 1500),
  lambdaMat1 = matrix(c(0.2, 0.1, 0.4, 0.1), 2, 2) / 365,
 lambdaMat2 = matrix(c(0.5, 0.2, 0.6, 0.2), 2, 2) / 365,
 lambdaProg = matrix(c(0.5, 0.5, 0.4, 0.4), 2, 2) / 365,
 p = c(0.8, 0.2), 
 timezero = FALSE, discrete_approximation = TRUE)
rSurv_fun(n = 10, x = A)

}
\seealso{
\code{\link{rSurv_conditional_fun}}, \code{\link{sample_fun}}, \code{\link{sample_conditional_fun}}
}
\author{
Robin Ristl, \email{robin.ristl@meduniwien.ac.at}
}
