% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nminfo.R
\name{nminfo}
\alias{nminfo}
\title{Get the most accurate information you can get from NONMEM}
\usage{
nminfo(
  file,
  mod = ".mod",
  xml = ".xml",
  ext = ".ext",
  cov = ".cov",
  phi = ".phi",
  lst = ".lst",
  grd = ".grd",
  useXml = TRUE,
  useExt = TRUE,
  useCov = TRUE,
  usePhi = TRUE,
  useLst = TRUE,
  strictLst = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{file}{nonmem file, like control stream, phi.  This function
will remove the extension to try to get the right information.
It preferentially selects the most accurate estimates from the
file.}

\item{mod}{the NONMEM output extension, defaults to \code{.mod}}

\item{xml}{the NONMEM xml file extension , defaults to \code{.xml}}

\item{ext}{the NONMEM ext file extension, defaults to \code{.ext}}

\item{cov}{the NONMEM covariance file extension, defaults to \code{.cov}}

\item{phi}{the NONMEM eta/phi file extension, defaults to \code{.phi}}

\item{lst}{the NONMEM output extension, defaults to \code{.lst}}

\item{grd}{the NONMEM gradient file extension, defaults to \code{.grd}}

\item{useXml}{if present, use the NONMEM xml file to import much of
the NONMEM information}

\item{useExt}{if present, use the NONMEM ext file to extract
parameter estimates (default \code{TRUE}), otherwise defaults to
parameter estimates extracted in the NONMEM output}

\item{useCov}{if present, use the NONMEM cov file to import the
covariance, otherwise import the covariance with list file}

\item{usePhi}{if present, use the NONMEM phi file to extract etas
(default \code{TRUE}), otherwise defaults to etas in the tables (if
present)}

\item{useLst}{if present, use the NONMEM lst file to extract NONMEM
information}

\item{strictLst}{The list parsing needs to be correct for a
successful load (default \code{FALSE}).}

\item{verbose}{this is a flag to be more verbose when reading information in, by default this is \code{FALSE}}
}
\value{
list of NONMEM information
}
\description{
Get the most accurate information you can get from NONMEM
}
\examples{
nminfo(system.file("mods/cpt/runODE032.res", package="nonmem2rx"))
}
\author{
Matthew L. Fidler
}
