% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qqnorm_geom.R
\name{stat_QQnorm}
\alias{stat_QQnorm}
\title{Quantile-Quantile Plots}
\usage{
stat_QQnorm(mapping = NULL, data = NULL, geom = "point",
  position = "identity", na.rm = FALSE, show.legend = NA,
  inherit.aes = TRUE, ...)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by aes or aes_.}

\item{data}{The data to be displayed in this layer.}

\item{geom}{Use to override the default geom}

\item{position}{Position adjustment, either as a string, or the result of a call to a position adjustment function.}

\item{na.rm}{If FALSE, the default, missing values are removed with a warning. If TRUE, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends? NA, the default, includes if any aesthetics are mapped. FALSE never includes, and TRUE always includes.}

\item{inherit.aes}{If FALSE, overrides the default aesthetics, rather than combining with them.}

\item{...}{other arguments passed on to layer.}
}
\description{
Quantile-Quantile Plots with ggplot2
}
\details{
Provide normal QQplot
}
\section{Aesthetics}{

geom_smooth understands the following aesthetics (required aesthetics are in bold):\cr
\bold{x}, alpha, colour, fill, group, shape, size, stroke
}

\examples{
dd<-data.frame(gr=c(rep("A",20),rep("B",40)))
dd$dv<-2*(dd$gr=="B")+rnorm(nrow(dd))/(1+2*(dd$gr=="A"))
dd<-dd[order(dd$gr,dd$dv),]
dd$px<-NA
for(gri in levels(dd$gr)){
  dd$px[dd$gr==gri]<-qqnorm(dd$dv[dd$gr==gri],plot=FALSE)$x
}
ggplot(dd, aes(dv)) +
  stat_QQnorm()+
  facet_wrap(~gr)
\dontrun{
ggplot(dd, aes(dv,color=factor(gr))) +
  stat_QQnorm()
  }
}
