% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/noisyCE2.R
\name{noisyCE2}
\alias{noisyCE2}
\alias{print.noisyCE2}
\alias{plot.noisyCE2}
\title{Cross-Entropy Optimisation of Noisy Functions}
\usage{
noisyCE2(f, domain, ..., rho = 0.05, N = 1000, smooth = NULL,
  stopwindow = tail(gam, n * (n > 20)), stoprule = ts_change(x),
  maxiter = 1000, maximise = TRUE, verbose = "v")

\method{print}{noisyCE2}(x, ...)

\method{plot}{noisyCE2}(x, what = c("x", "gam", "param"), start = NULL,
  end = NULL, ...)
}
\arguments{
\item{f}{objective function which takes the vector of optimisation variables
as first argument.}

\item{domain}{a \code{list} (or other coercible objects) where each component
specifies the domain of each variable of the objective function \code{f}.
The components of the list may be either objects of \code{typevar} class (see
\link{type_variable}) or strings identifying one of \link{type_variable} functions
(for example \code{"real"} for function \code{\link[=type_real]{type_real()}}). See § Examples.}

\item{...}{other arguments to be passed to \code{f} or to other methods (for
\code{print} and \code{plot}).}

\item{rho}{parameter \eqn{\rho} of the Cross-Entropy algorithm. This argument
may be passed either as a numeric value in \eqn{(0,1)} or as an unevaluated
expression which may include the number of current iteration \code{n}, or the
argument \code{N}.}

\item{N}{parameter \eqn{N} of the Cross-Entropy algorithm. This argument
may be passed either as a positive integer or as an unevaluated expression
which may include the number of current iteration \code{n}.}

\item{smooth}{list of unevaluated expressions to be used as smoothing rules
for the parameters of the sampling probability distributions of \strong{all
variables}. If not \code{NULL}, all default or set smoothing rules of all
variables will be overwritten. See \link{type_variable} for details and examples.}

\item{stopwindow}{unevaluated expression returning the object to be passed to
the stopping rule. Symbol \code{gam} permits the time series \eqn{\gamma_t} to
be used (as a \code{numeric} vector).}

\item{stoprule}{stopping rule passed as an unevaluated expression including
\code{x} as the object returned by evaluation of argument \code{stopwindow}. The
algorithm is stopped when zero is returned by the evaluation of \code{stoprule}.
If returned object has attribute \code{mess}, this is used as a message.
Currently, built-in stopping rules are \code{\link[=ts_change]{ts_change()}} and \code{\link[=geweke]{geweke()}}, others
may be defined by user.}

\item{maxiter}{maximum number of iteration. When it is reached, algorithm is
stopped whether or not the stopping criterion is satisfied. If the maximum
number of iteration is reached, the \code{code} and the \code{message} components of
\code{noisyCE} object are overwritten.}

\item{maximise}{if \code{TRUE} (default) \code{f} is maximised, otherwise a minimisation
of \code{f} is performed.}

\item{verbose}{algorithm verbosity (values \code{v}, \code{vv} and \code{vvv} are admitted).}

\item{x}{object of class \code{noisyCE2}, as returned by \code{noisyCE2}.}

\item{what}{type of plot should be drawn. If \code{what = "x"} (default), values
of the variables are plotted as time series; if \code{what = "gam"}, time series
of statistics \eqn{\gamma} is plotted; if \code{what = "param"}, time series of
parameters of the sampling distributions are plotted.}

\item{start, end}{first and last value to be plotted. If \code{NULL}, all values are
plotted.}
}
\value{
An object of class \code{noisyCE2} structured as a list with the following
components:
\item{f}{argument \code{f}.}
\item{fobj}{objective function \code{f} where possible arguments passed through
argument \code{...} have been substituted. Thus, the value of the objective
function maximised by \code{noisyCE} in \code{x0} can be computed as \code{fobj(x0)}. If
a minimisation has been performed, \code{fobj} returns \code{f} with sign inverted.}
\item{xopt}{\code{numeric} vector with solution.}
\item{hxopt}{matrix of \code{niter} rows and \code{length(xopt)} columns with values of
variables generated by the optimisation algorithm.}
\item{param}{\code{list} of \code{length(xopt)} components where time series of
parameters (vectors \eqn{v_t}) are stored for each variable as \code{data.frame}
objects with \code{niter+1} rows (the first rows are the starting values set
through function \code{noisyCEcontrol}).}
\item{gam}{vector of values \eqn{\gamma_t}.}
\item{niter}{number of iterations.}
\item{code}{convergence code of the algorithm. Value \code{0} means that algorithm
has converged; other values are defined according to the stopping rule.}
\item{convMess}{textual message associated to the convergence code (if any).}
}
\description{
Unconstraint optimisation of noisy functions through the cross-entropy
algorithm.
}
\section{Methods (by generic)}{
\itemize{
\item \code{print}: display synthetic information about a \code{noisyCE2} object

\item \code{plot}: plot various components of a \code{noisyCE2} object
}}

\examples{
library(magrittr)
# Optimisation of the 4-dimensional function:
# f(x1,x2,x3,x4)=-(x1-1)^2-(x2-2)^2-(x3-3)^2-(x4-4)^2
sol <- noisyCE2(function(x) -sum((x - (1:4))^2), domain = rep('real', 4))
# Representation of the convergence process:
plot(sol, what = 'x')
plot(sol, what = 'gam')

}
