\name{australia}
\docType{data}
\alias{australia}
\title{Data from Australian subset of PISA 2009 data}
\description{
  The data stem from the large-scale assessment study PISA 2009
  (Organisation for Economic Co-Operation and Development, 2010) where
  competencies of 15-year-old students in reading, mathematics, and science
  are assessed using nationally representative samples in 3-year cycles. In
  this example, data from the student background questionnaire from the
  Australian sample of PISA 2009 were used. Only data of students with complete
  responses (N = 1,069) were considered.
}
\usage{data(jordan)}
\format{
  A data frame of nine variables and 1,069 observations:
  \describe{
    \item{x1}{indicator for reading attitude, mean of items ST24Q04, ST24Q09, ST24Q01, and ST24Q03.}
    \item{x2}{indicator for reading attitude, mean of items ST24Q02, ST24Q05, ST24Q07, and ST24Q06.}
    \item{x3}{indicator for reading attitude, mean of items ST24Q08, ST24Q10, and ST24Q11.}
    \item{x4}{indicator for online activities, mean of items ST26Q02, ST26Q07, and ST26Q04.}
    \item{x5}{indicator for online activities, mean of items ST26Q03, and ST26Q06.}
    \item{x6}{indicator for online activities, mean of items ST26Q01, and ST26Q05.}
    \item{y1}{indicator for reading skill, mean of items R06, R102, and R219.}
    \item{y2}{indicator for reading skill, mean of items R220, R414, and R447.}
    \item{y3}{indicator for reading skill, mean of items R452 and R458.}
  }
}
\source{
Organisation for Economic Co-Operation and Development (2010). \emph{Pisa 2009
results: What students know and can do - Student performance in reading,
mathematics and science} (Tech. Rep.). Paris, France. Obtained from:
\url{http://www.oecd.org/pisa/pisaproducts/pisa2009database-downloadabledata.htm}
}
\examples{
data(australia)
}
\keyword{datasets}

