% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_gnls.R
\name{simulate_gnls}
\alias{simulate_gnls}
\title{Simulate fitted values from an object of class \code{\link[nlme]{gnls}}}
\usage{
simulate_gnls(
  object,
  psim = 1,
  na.action = na.fail,
  naPattern = NULL,
  data = NULL,
  ...
)
}
\arguments{
\item{object}{object of class \code{\link[nlme]{gnls}}}

\item{psim}{parameter simulation level, 0: for fitted values, 1: for simulation from 
fixed parameters (assuming a fixed vcov matrix), 2: for simulation considering the 
uncertainty in the residual standard error (sigma), this returns data which
will appear similar to the observed values}

\item{na.action}{default \sQuote{na.fail}. See \code{\link[nlme]{predict.gnls}}}

\item{naPattern}{missing value pattern. See \code{\link[nlme]{predict.gnls}}}

\item{data}{the data argument is needed when using this function inside user defined functions.}

\item{...}{additional arguments (it is possible to supply a newdata this way)}
}
\value{
It returns a vector with simulated values with length equal to the number of rows 
in the original data
}
\description{
Simulate values from an object of class gnls. Unequal variances, 
as modeled using the \sQuote{weights} option are supported, and there is experimental
code for dealing with the \sQuote{correlation} structure.
}
\details{
This function is based on \code{\link[nlme]{predict.gnls}} function

It uses function \code{\link[MASS]{mvrnorm}} to generate new values for the coefficients
of the model using the Variance-Covariance matrix \code{\link{vcov}}. This variance-covariance matrix 
refers to the one for the parameters 'beta', not the one for the residuals.
}
\examples{
\donttest{
require(nlme)
data(barley, package = "nlraa")

fit.gnls <- gnls(yield ~ SSlinp(NF, a, b, xs), data = barley)

sim <- simulate_gnls(fit.gnls)
}
}
\seealso{
\code{\link[nlme]{predict.gnls}}
}
