% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UNI.initial_helper.R
\name{getUNI.initial}
\alias{getUNI.initial}
\title{Compute Initial Values for Parameters of Latent Growth Curve Models or Latent Change Score Models with Time-invariant
Covariates (If Any)}
\usage{
getUNI.initial(dat, t_var, y_var, curveFun, records, growth_TIC, res_scale)
}
\arguments{
\item{dat}{A wide-format data frame, with each row corresponding to a unique ID. It contains the observed variables with
repeated measurements and occasions, and time-invariant covariates (TICs) if any. It takes the value passed from \code{getLGCM()}
or \code{getLCSM()}.}

\item{t_var}{A string specifying the prefix of the column names corresponding to the time variable at each study wave.
It takes the value passed from \code{getLGCM()} or \code{getLCSM()}.}

\item{y_var}{A string specifying the prefix of the column names corresponding to the outcome variable at each study wave.
It takes the value passed from \code{getLGCM()} or \code{getLCSM()}.}

\item{curveFun}{A string specifying the functional form of the growth curve. Supported options for latent growth curve models include:
\code{"linear"} (or \code{"LIN"}), \code{"quadratic"} (or \code{"QUAD"}), \code{"negative exponential"}
(or \code{"EXP"}), \code{"Jenss-Bayley"} (or \code{"JB"}), and \code{"bilinear spline"} (or \code{"BLS"}). Supported options for
latent change score models include: \code{"quadratic"} (or \code{"QUAD"}), \code{"negative exponential"} (or \code{"EXP"}),
\code{"Jenss-Bayley"} (or \code{"JB"}), and \code{"nonparametric"} (or \code{"NonP"}). It takes the value passed from \code{getLGCM()}
or \code{getLCSM()}.}

\item{records}{A numeric vector specifying indices of the study waves. It takes the value passed from \code{getLGCM()} or \code{getLCSM()}.}

\item{growth_TIC}{A string or character vector specifying the column name(s) of time-invariant covariate(s) contributing to the
variability of growth factors if any. It takes the value passed from \code{getLGCM()} or \code{getLCSM()}.}

\item{res_scale}{A numeric value representing the scaling factor for the initial calculation of the residual variance. This
value should be between \code{0} and \code{1}, exclusive. It takes the value passed from \code{getLGCM()} or \code{getLCSM()}.}
}
\value{
A list containing the initial values for parameters related to growth factors, TICs (if any), and path
coefficients (if any) of a latent growth curve model or a latent change score model. The returned list has the
following structure:
\describe{
  \item{Y_starts:}{A list containing three elements:
  \describe{
    \item{alpha0 or mean0:}{Depends on whether \code{growth_TIC} is provided,}
    \item{psi_r or psi0:}{Depends on whether \code{growth_TIC} is provided,}
    \item{residuals.}{}
  }}
  \item{TIC_starts:}{Only provided when \code{growth_TIC} is not NULL.}
  \item{beta0:}{Only provided when \code{growth_TIC} is not NULL.}
}
Each of these elements is a numeric vector or matrix containing the initial parameter estimates.
}
\description{
This function computes the initial values of the parameters for a latent growth curve model or a latent change
score model with time-invariant covariates (if any).
}
\keyword{internal}
