% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TVC.mxModel_helper.R
\name{getTVC.mxModel}
\alias{getTVC.mxModel}
\title{Construct An Object of mxModel for Latent Growth Curve Models or Latent Change Score Models with a Time
Varying Covariate and Time-invariant Covariates (If Any) To Be Evaluated}
\usage{
getTVC.mxModel(
  dat,
  t_var,
  y_var,
  curveFun,
  intrinsic,
  records,
  y_model,
  TVC,
  decompose,
  growth_TIC,
  starts
)
}
\arguments{
\item{dat}{A wide-format data frame, with each row corresponding to a unique ID. It contains the observed variables with
repeated measurements (for the longitudinal outcome and time-varying covariates), occasions, and time-invariant covariates
(TICs) if any. It takes the value passed from \code{getTVCmodel()}.}

\item{t_var}{A string specifying the prefix of the column names corresponding to the time variable at each study wave.
It takes the value passed from \code{getTVCmodel()}.}

\item{y_var}{A string specifying the prefix of the column names corresponding to the outcome variable at each study wave.
It takes the value passed from \code{getTVCmodel()}.}

\item{curveFun}{A string specifying the functional form of the growth curve. Supported options for \code{y_model =
"LGCM"} include: \code{"linear"} (or \code{"LIN"}), \code{"quadratic"} (or \code{"QUAD"}), \code{"negative exponential"}
(or \code{"EXP"}), \code{"Jenss-Bayley"} (or \code{"JB"}), and \code{"bilinear spline"} (or \code{"BLS"}). Supported
options for \code{y_model = "LCSM"} include: \code{"quadratic"} (or \code{"QUAD"}), \code{"negative exponential"}
(or \code{"EXP"}), \code{"Jenss-Bayley"} (or \code{"JB"}), and \code{"nonparametric"} (or \code{"NonP"}). It takes the
value passed from \code{getTVCmodel()}.}

\item{intrinsic}{A logical flag indicating whether to build an intrinsically nonlinear longitudinal model. It takes the
value passed from \code{getTVCmodel()}.}

\item{records}{A numeric vector specifying the indices of the observed study waves. It takes the value passed from
\code{getTVCmodel()}.}

\item{y_model}{A string specifying how to fit the longitudinal outcome. Supported values are \code{"LGCM"} and \code{"LCSM"}.
It takes the value passed from \code{getTVCmodel()}.}

\item{TVC}{A string specifying the prefix of the column names corresponding to the time-varying covariate at each study wave.
It takes the value passed from \code{getTVCmodel()}.}

\item{decompose}{An integer specifying the decomposition option for temporal states. Supported values include \code{0} (no
decomposition), \code{1} (decomposition with interval-specific slopes as temporal states), \code{2} (decomposition with interval-
specific changes as temporal states), and \code{3} (decomposition with change-from-baseline as temporal states). It takes the
value passed from \code{getTVCmodel()}.}

\item{growth_TIC}{A string or character vector specifying the column name(s) of time-invariant covariate(s) that account for the
variability of growth factors, if any. It takes the value passed from \code{getTVCmodel()}.}

\item{starts}{A list of initial values for the parameters, either takes the value passed from \code{getTVCmodel()}
or derived by the helper function \code{getTVC.initial()}.}
}
\value{
A pre-optimized mxModel for a latent growth curve model or a latent change score model with a
time-varying covariate and time-invariant covariates (if any).
}
\description{
This function builds up an object of mxModel for a latent growth curve model or latent change score model
with user-specified functional form (including whether intrinsically nonlinear), time-varying covariate,
and with time-invariant covariates (if any).
}
