% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getWindowCoords.R
\name{getWindowCoords}
\alias{getWindowCoords}
\title{Get lower and upper windows coordinates}
\usage{
getWindowCoords(
  scaledHabGridCenter = scaledHabGridCenter,
  scaledObsGridCenter = NULL,
  plot.check = TRUE
)
}
\arguments{
\item{scaledHabGridCenter}{A matrix with the scaled "x" and "y" habitat windows grid cell centers (after using \code{\link{scaleCoordsToHabitatGrid}}).}

\item{scaledObsGridCenter}{A matrix with the scaled "x" and "y" observation windows grid cell centers (afer using \code{\link{scaleCoordsToHabitatGrid}}). 
This is an optional argument and only necessary when modelling detection as a point process (e.g. \code{\link{dpoisppDetection_normal}}).}

\item{plot.check}{A visualization option (if TRUE); displays habitat and detection windows.}
}
\value{
A list of objects :
 
\itemize{
\item \emph{lowerHabCoords} A matrix with the "x" and "y" lower habitat window coordinates.
\item \emph{upperHabCoords} A matrix with the "x" and "y" upper habitat window coordinates.
\item \emph{habitatGrid} A matrix of habitat cell ID that can be used to lookup efficiently the cell ID from a coordinate scaled to the habitat grid:
habitatGrid[trunc(scaledHabGridCenter[1,"y"]) + 1, trunc(scaledHabGridCenter[1,"x"]) + 1]. See \code{\link{scaleCoordsToHabitatGrid}} for more details.
\item \emph{lowerObsCoords} A matrix with the "x" and "y" lower observation window coordinates. Only returned when \emph{scaledObsGridCenter} is provided.
\item \emph{upperObsCoords} A matrix with the "x" and "y" upper observation window coordinates. Only returned when \emph{scaledObsGridCenter} is provided.


}
}
\description{
The \code{getWindowCoords} is an R utility function to create lower and upper habitat and observation windows coordinates, as well an habitat grid with cell ids. 
Those objects are necessary to run all point process (pp) functions. All input data should be scaled to the habitat grid using \code{\link{scaleCoordsToHabitatGrid}}. 
Note that we assume homogeneous window sizes.
}
\examples{
coordsGridCenter <- expand.grid(list(x = seq(50.5, 100, 1),
                                     y = seq(100.5, 150, 1)))
coordsData <- expand.grid(list(x = seq(60, 90, 1),
                               y = seq(110, 140, 1)))

plot(coordsGridCenter[,2] ~ coordsGridCenter[,1])
points(coordsData[,2] ~ coordsData[,1], col="red")
scaled <- scaleCoordsToHabitatGrid(coordsData = coordsData
                                   , coordsHabitatGridCenter = coordsGridCenter)
plot(scaled$coordsHabitatGridCenterScaled[,2] ~ scaled$coordsHabitatGridCenterScaled[,1])
points(scaled$coordsDataScaled[,2] ~ scaled$coordsDataScaled[,1], col="red")

LowerAndUpperCoords <- getWindowCoords(scaledHabGridCenter = scaled$coordsHabitatGridCenterScaled,
                                         scaledObsGridCenter = scaled$coordsDataScaled)

# Plot habitat window cell centers and lower/upper coordinates 
plot(scaled$coordsHabitatGridCenterScaled[,2] ~ 
     scaled$coordsHabitatGridCenterScaled[,1], 
     pch=16, cex=0.3, col=grey(0.5))
points(LowerAndUpperCoords$lowerHabCoords[,2] ~ 
       LowerAndUpperCoords$lowerHabCoords[,1],
       pch=16, cex=0.3, col=grey(0.1))
points(LowerAndUpperCoords$upperHabCoords[,2] ~
       LowerAndUpperCoords$upperHabCoords[,1],
       pch=16, cex=0.3, col=grey(0.1))

# Plot observation window cells center and lower/upper coordinates
points(scaled$coordsDataScaled[,2]~scaled$coordsDataScaled[,1], pch=16,
 cex=0.3, col = adjustcolor("red",alpha.f = 0.8))
points(LowerAndUpperCoords$lowerObsCoords[,2] ~ 
        LowerAndUpperCoords$lowerObsCoords[,1],
       pch=16, cex=0.3, col = adjustcolor("red", alpha.f = 0.8))
points(LowerAndUpperCoords$upperObsCoords[,2] ~
       LowerAndUpperCoords$upperObsCoords[,1],
       pch=16, cex=0.3, col = adjustcolor("red", alpha.f = 0.8))
       
}
\author{
Cyril Milleret
}
