% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dpoisppAC.R
\name{dpoisppAC}
\alias{dpoisppAC}
\alias{rpoisppAC}
\title{Poisson point process for the distribution of activity centers}
\usage{
dpoisppAC(
  x,
  lowerCoords,
  upperCoords,
  logIntensities,
  sumIntensity,
  habitatGrid,
  numGridRows,
  numGridCols,
  numPoints,
  log = 0
)

rpoisppAC(
  n,
  lowerCoords,
  upperCoords,
  logIntensities,
  sumIntensity,
  habitatGrid,
  numGridRows,
  numGridCols,
  numPoints
)
}
\arguments{
\item{x}{Matrix of x- and y-coordinates of a set of spatial points (AC locations). Each row corresponds to a point.}

\item{lowerCoords, upperCoords}{Matrices of lower and upper x- and y-coordinates of all habitat windows. One row for each window.
Each window should be of size 1x1 (after rescaling if necessary).}

\item{logIntensities}{Vector of log habitat intensities for all habitat windows.}

\item{sumIntensity}{Sum of the habitat intensities over all windows. This can be obtained using \code{logIntensities}.}

\item{habitatGrid}{Matrix of habitat window indices. Habitat window indices should match the order in \code{lowerCoords}, \code{upperCoords}, and \code{logIntensities}. 
When the grid has only one row/column, artificial indices have to be provided to inflate \code{habitatGrid} to be able to use the distribution in \code{nimble} model code.}

\item{numGridRows, numGridCols}{Numbers of rows and columns of the habitat grid.}

\item{numPoints}{Number of points in the Poisson point process. This value (non-negative integer) is used to truncate \code{x} 
so that extra rows beyond \code{numPoints} are ignored.}

\item{log}{Logical argument, specifying whether to return the log-probability of the distribution.}

\item{n}{Integer specifying the number of realisations to generate. Only n = 1 is supported.}
}
\value{
\code{dpoisppAC} gives the (log) probability density of the observation matrix \code{x}. 
\code{rpoisppAC} gives coordinates of a set of randomly generated spatial points.
}
\description{
Density and random generation functions of the Poisson point process for the distribution of activity centers. 
The \code{dpoisppAC} distribution is a NIMBLE custom distribution which can be used to model and simulate
activity center locations (\emph{x}) of multiple individual in continuous space over a set of habitat windows defined by their upper and lower
coordinates (\emph{lowerCoords,upperCoords}). The distribution assumes that activity centers  
follow a Poisson point process with intensity = \emph{exp(logIntensities)}.
}
\examples{
lowerCoords <- matrix(c(0, 0, 1, 0, 0, 1, 1, 1), nrow = 4, byrow = TRUE)
upperCoords <- matrix(c(1, 1, 2, 1, 1, 2, 2, 2), nrow = 4, byrow = TRUE)
logIntensities <- log(c(1:4))
logSumIntensity <- sum(exp(logIntensities))
habitatGrid <- matrix(c(1:4), nrow = 2, byrow = TRUE)
numGridRows <- nrow(habitatGrid)
numGridCols <- ncol(habitatGrid)
#Simulate data
x <- rpoisppAC(1, lowerCoords, upperCoords, logIntensities, logSumIntensity, habitatGrid,
               numGridRows, numGridCols, -1)
numPoints <- nrow(x)
dpoisppAC(x, lowerCoords, upperCoords, logIntensities, logSumIntensity,
          habitatGrid, numGridRows, numGridCols, numPoints, log = TRUE)
          
}
\references{
W. Zhang, J. D. Chipperfield, J. B. Illian, P. Dupont, C. Milleret, P. de Valpine and R. Bischof. 2020. 
A hierarchical point process model for spatial capture-recapture data. bioRxiv. DOI 10.1101/2020.10.06.325035
}
\author{
Wei Zhang
}
