% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Laplace.R
\name{summaryLaplace}
\alias{summaryLaplace}
\title{Summarize results from Laplace approximation}
\usage{
summaryLaplace(
  laplace,
  MLEoutput,
  originalScale = TRUE,
  randomEffectsStdError = FALSE,
  jointCovariance = FALSE
)
}
\arguments{
\item{laplace}{The Laplace approximation object, typically the compiled one.
This would be the result of compiling an object returned from
`buildLaplace`.}

\item{MLEoutput}{The maximum likelihood estimate using Laplace approximation,
returned from `laplace$findMLE(...)`. See `help(buildLaplace)` for more
information.}

\item{originalScale}{Should results be returned using the original
parameterization in the model code (TRUE) or the potentially transformed
parameterization used internally by the Laplace approximation (FALSE).
Transformations are used for any parameters and/or random effects that have
constrained ranges of valid values, so that in the transformed parameter
space there are no constraints.}

\item{randomEffectsStdError}{If TRUE, calculate the standard error of the
estimates of random effects values.}

\item{jointCovariance}{If TRUE, calculate the joint covariance matrix of
the parameters and random effects together. If FALSE, calculate the 
covariance matrix of the parameters.}
}
\value{
A list with data frames `params` and `randomEffects`, each with columns for
`estimate` and (possibly) `se` (standard error) and row names for model
nodes, a matrix `vcov` with the covariance matrix with row and column names,
and `originalScale` with the input value of `originalScale` so it is recorded
for later use if wanted.
}
\description{
Process the results of the `findMLE` method of a nimble Laplace approximation
into a more useful format.
}
\details{
The numbers obtained by this function can be obtained more directly by
`laplace$summary(...)`, which calls a (usually compiled) method of the
`laplace` nimbleFunction. The added benefit of `summaryLaplace` is to arrange
the results into data frames (for parameters and random effects), with row
names for the model nodes, and also adding row and column names to the
covariance matrix.
}
