% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in RtmpAaCNOd/file312c33fb9092
\name{Multivariate-t}
\alias{Multivariate-t}
\alias{dmvt_chol}
\alias{multivariate-t}
\alias{mvt}
\alias{rmvt_chol}
\title{The Multivariate t Distribution}
\usage{
dmvt_chol(x, mu, cholesky, df, prec_param = TRUE, log = FALSE)

rmvt_chol(n = 1, mu, cholesky, df, prec_param = TRUE)
}
\arguments{
\item{x}{vector of values.}

\item{mu}{vector of values giving the location of the distribution.}

\item{cholesky}{upper-triangular Cholesky factor of either the precision matrix (i.e., inverse scale matrix) (when \code{prec_param} is TRUE) or scale matrix (otherwise).}

\item{df}{degrees of freedom.}

\item{prec_param}{logical; if TRUE the Cholesky factor is that of the precision matrix; otherwise, of the scale matrix.}

\item{log}{logical; if TRUE, probability density is returned on the log scale.}

\item{n}{number of observations (only \code{n=1} is handled currently).}
}
\value{
\code{dmvt_chol} gives the density and \code{rmvt_chol} generates random deviates.
}
\description{
Density and random generation for the multivariate t distribution, using the Cholesky factor of either the precision matrix (i.e., inverse scale matrix) or the scale matrix.
}
\details{
See Gelman et al., Appendix A or the BUGS manual for mathematical details. The 'precision' matrix as used here is defined as the inverse of the scale matrix, \eqn{\Sigma^{-1}}, given in Gelman et al.
}
\examples{
mu <- c(-10, 0, 10)
scalemat <- matrix(c(1, .9, .3, .9, 1, -0.1, .3, -0.1, 1), 3)
ch <- chol(scalemat)
x <- rmvt_chol(1, mu, ch, df = 1, prec_param = FALSE)
dmvt_chol(x, mu, ch, df = 1, prec_param = FALSE)
}
\author{
Peter Sujan
}
\references{
Gelman, A., Carlin, J.B., Stern, H.S., and Rubin, D.B. (2004) \emph{Bayesian Data Analysis}, 2nd ed. Chapman and Hall/CRC.
}
\seealso{
\link{Distributions} for other standard distributions
}

