% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in RtmpK6dyXN/file1e09152c4c9e
\name{setAndCalculateOne}
\alias{setAndCalculateOne}
\title{Creates a nimbleFunction for setting the value of a scalar model node,
calculating the associated deterministic dependents and logProb values,
and returning the total sum log-probability.}
\usage{
setAndCalculateOne(model, targetNode)
}
\arguments{
\item{model}{An uncompiled or compiled NIMBLE model.  This argument is required.}

\item{targetNode}{The character name of any scalar node in the model object.  This argument is required.}
}
\description{
This nimbleFunction generator must be specialized to any model object and any scalar model node.
A specialized instance of this nimbleFunction will set the value of the target node in the specified model,
calculate the associated logProb, calculate the values of any deterministic dependents,
calculate the logProbs of any stochastic dependents,
and return the sum log-probability associated with the target node and all stochastic dependent nodes.
}
\details{
Calling setAndCalculateOne(model, targetNode) will return a function with a single, required argument:

targetValue: The numeric value which will be put into the target node, in the specified model object.
}
\examples{
code <- nimbleCode({ for(i in 1:3) x[i] ~ dnorm(0, 1) })
Rmodel <- nimbleModel(code)
my_setAndCalc <- setAndCalculateOne(Rmodel, 'x[1]')
lp <- my_setAndCalc$run(2)
}
\author{
Daniel Turek
}

