% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in RtmpK6dyXN/file1e0943c797ed
\name{compareMCMCs}
\alias{compareMCMCs}
\title{Run multiple MCMCs (packages or NIMBLE cases) for multiple models and return summary results}
\usage{
compareMCMCs(modelInfo, MCMCs = c("nimble"), MCMCdefs, BUGSdir, stanDir,
  stanInfo, doSamplePlots = FALSE, verbose = TRUE, summary = TRUE, ...)
}
\arguments{
\item{modelInfo}{A set of model information for which one or more MCMCs should be run.  Can take one of several formats: (1) a character vector of names of classic WinBUGS examples.  (2) for one model, a list with elements \code{code} (containing the model code as returned by \code{\link{nimbleCode}}), \code{data} (containing a list of data that can be provided to \code{\link{nimbleModel}}, \code{constants} (containing a list of constants to be provided to \code{\link{nimbleModel}}), \code{inits} (containing a list of initial values that can be provided to \code{\link{nimbleModel}}; this is optional unless it is needed to match names in some of the other arguments, as described below), and \code{name} (a character name; this is optional).  (3) for multiple models, a list of lists formatted as per option (2).  See \code{\link{nimbleModel}} about handling of data vs. constants.  In particular, if both are provided in data, then \code{nimbleModel} will try to determine which is which.}

\item{MCMCs}{An object acceptable as the \code{MCMCs} argument to \code{\link{MCMCsuite}}.  This specifies the set of MCMCs to be run.  Valid entries include 'jags', 'nimble', 'nimble_RW', 'nimble_slice', 'autoBlock', 'stan', 'winbugs', 'openbugs', or a name provided in the \code{MCMCdefs} list.}

\item{MCMCdefs,}{An optional object acceptable as the \code{MCMCdefs} argument to \code{\link{MCMCsuite}}.}

\item{BUGSdir}{If \code{models} is a character vector of WinBUGS example names, \code{BUGSdir} can optionally provide the directory (as a character string) where to find them.  If missing, they will be looked up in the installed \code{nimble} package using \code{\link{getBUGSexampleDir}}.}

\item{stanDir}{Optional base directory in which Stan model code will be found (but \code{stanInfo} can override this).}

\item{stanInfo}{A list of information for finding and using the Stan code for each model.  If names of list elements are provided, they will be used to match either the character vector of names provided for \code{models} (option (1)) or the list names of \code{models} (options (2) or (3)).  If names are not provided, the models will be used in order.  Each element must be a list that can or must include (i) \code{dir} (optional: the subdirectory to use, instead of \code{stanDir}; often the subdirectory is the model name). (ii) \code{codeFile} (optional: the name of the stan code file, to which ".stan" will be appended if not already there; if omitted, this will be set to the value of \code{modelName}. (iii) \code{data} (optional: the name of a the stan data file, to which ".data.R" will be appended if not already there; if omitted, the system will try using stanCodeFile with ".data.R" appended). (iv) \code{inits} (optional: the name of a the stan inits file, to which ".init.R" will be appended if not already there; if omitted, the system will try using stanCodeFile with ".init.R" appended). (v) \code{modelName} (optional: a name for the model; if omitted, a value from the \code{models} argument will be used). (vi) \code{stanParameterRules} (optional: a list whose names are BUGS variable names, with each element a list with element \code{StanSourceName} to give the corresponding Stan variable name and \code{transform} to give a function that converts a value of the Stan variable to a value of the BUGS variable).}

\item{doSamplePlots}{(default FALSE) This is passed to \code{\link{MCMCsuite}} as both the \code{makePlots} and \code{savePlots} argument.}

\item{verbose}{(default FALSE) If TRUE, a message will be shown about which model is being worked on.}

\item{summary}{(deafault TRUE) If TRUE, the return value will be a list with elements \code{summary}, \code{timing} and \code{efficiency}.  If FALSE, the return value will be the return value generated by \code{MCMCsuite}.  Among other things, the latter contains the actual samples.}

\item{...}{additional arguments to be passed to \code{\link{MCMCsuite}}.}
}
\value{
If \code{summary} is FALSE, \code{compareMCMCs} returns the object returned by \code{MCMCsuite}, which comes from \code{\link{MCMCsuiteClass}}.  If \code{summary} is TRUE, it returns a list with elements timing, efficiency, and summary.
}
\description{
Manages the input and output for multiple calls to MCMCsuite to generate comparisons among MCMCs
}
\details{
compareMCMCs wraps a call to \code{\link{MCMCsuite}}
}
\seealso{
\code{\link{MCMCsuiteClass}}, \code{\link{updateMCMCcomparisonWithHighOrderESS}}, \code{\link{make_MCMC_comparison_pages}}, \code{\link{reshape_comparison_results}}, \code{\link{combine_MCMC_comparison_results}}, \code{\link{rename_MCMC_comparison_method}}, \code{\link{reshape_comparison_results}}.
}

