% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in RtmpK6dyXN/file1e096c0e1906
\name{buildLiuWestFilter}
\alias{buildLiuWestFilter}
\title{Create a Liu and West particle filter algorithm.}
\usage{
buildLiuWestFilter(model, nodes, params = NULL, control = list())
}
\arguments{
\item{model}{A NIMBLE model object, typically representing a state
space model or a hidden Markov model}

\item{nodes}{A character vector specifying the latent model nodes
over which the particle filter will stochastically integrate over to
estimate the log-likelihood function}

\item{params}{A character vector specifying the top-level parameters to estimate the posterior distribution of.
 If unspecified, parameter nodes are specified as all stochastic top level nodes which
are not in the set of latent nodes specified in \code{nodes}.}

\item{control}{A list specifying different control options for the particle filter.  Options are described in the details section below.}
}
\description{
Create a Liu and West particle filter algorithm for a given NIMBLE state space model.
}
\details{
Each of the \code{control()} list options are described in detail below:
\describe{
 \item{d}{A discount factor for the Liu-West filter.  Should be close to,
 but not above, 1.}
 \item{saveAll}{Indicates whether to save state samples for all time points (TRUE), or only for the most recent time point (FALSE)}
\item{timeIndex}{An integer used to manually specify which dimension of the latent state variable indexes time.
 Only needs to be set if the number of time points is less than or equal to the size of the latent state at each time point.}
}

 The Liu and West filter samples from the posterior
 distribution of both the latent states and top-level parameters for a state space model.
 Each particle in the Liu and West filter contains values not only for latent states,
 but also for top level parameters.  Latent states are propogated via an auxiliary step,
 as in the auxiliary particle filter (\code{\link{buildAuxiliaryFilter}}).
 Top-level parameters are propagated from one
 time point to the next through a smoothed kernel density based on previous particle values.

 The resulting specialized particle filter algorthm will accept a
 single integer argument (\code{m}, default 10,000), which specifies the number
 of random \'particles\' to use for sampling from the posterior distributions.  The algorithm  saves
 unequally weighted samples from the posterior distribution of the latent
 states and top-level parameters in \code{mvWSamples}, with corresponding logged weights in \code{mvWSamples['wts',]}.
 An equally weighted sample from the posterior can be found in \code{mvEWSamples}.

 Note that if \code{saveAll=TRUE}, the top-level parameter samples given in the \code{mvWSamples} output will correspond to the weights from the final time point.
}
\examples{
\dontrun{
model <- nimbleModel(code = ...)
my_LWF <- buildLiuWestFilter(model, 'x[1:100]', params = 'sigma_x')
Cmodel <- compileNimble(model)
Cmy_LWF <- compileNimble(my_LWF, project = model)
Cmy_LWF$run(100000)
lw_X <- as.matrix(Cmy_LWF$mvEWSamples, 'x')

#  samples from posterior of a top level parameter named sigma_x:
lw_sigma_x <- as.matrix(Cmy_LWF$mvEWSamples, 'sigma_x')
}
}
\author{
Nicholas Michaud
}
\references{
Liu, J., and M. West. (2001). Combined parameter and state estimation in simulation-based filtering. \emph{Sequential Monte Carlo methods in practice}. Springer New York, pages 197-223.
}

