% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nimbleFunction_core.R
\name{nimbleFunction}
\alias{nimbleFunction}
\title{create a nimbleFunction}
\usage{
nimbleFunction(
  setup = NULL,
  run = function() { },
  methods = list(),
  globalSetup = NULL,
  contains = NULL,
  enableDerivs = list(),
  name = NA,
  check = getNimbleOption("checkNimbleFunction"),
  where = getNimbleFunctionEnvironment()
)
}
\arguments{
\item{setup}{An optional R function definition for setup processing.}

\item{run}{An optional NIMBLE function definition that executes the primary job of the nimbleFunction}

\item{methods}{An optional named list of NIMBLE function definitions for other class methods.}

\item{globalSetup}{For internal use only}

\item{contains}{An optional object returned from \code{\link{nimbleFunctionVirtual}} that defines arguments and returnTypes for \code{run} and/or methods, to which the current nimbleFunction must conform}

\item{enableDerivs}{EXPERIMENTAL A list of names of function methods to enable derivatives for.  Currently only for developer use.}

\item{name}{An optional name used internally, for example in generated C++ code.  Usually this is left blank and NIMBLE provides a name.}

\item{check}{Boolean indicating whether to check the run code for function calls that NIMBLE cannot compile. Checking can be turned off for all calls to \code{nimbleFunction} using \code{nimbleOptions(checkNimbleFunction = FALSE)}.}

\item{where}{An optional \code{where} argument passed to \code{setRefClass} for where the reference class definition generated for this nimbleFunction will be stored.  This is needed due to R package namespace issues but should never need to be provided by a user.}
}
\description{
create a nimbleFunction from a setup function, run function, possibly other methods, and possibly inheritance via \code{contains}
}
\details{
This is the main function for defining nimbleFunctions.  A lot of information is provided in the NIMBLE User Manual, so only a brief summary will be given here.

If a \code{setup} function is provided, then \code{nimbleFunction} returns a generator: a function that when called with arguments for the setup function will execute that function and return a specialized nimbleFunction.   The \code{run} and other methods can be called using \code{$} like in other R classes, e.g. \code{nf$run()}. The methods can use objects that were created in or passed to the \code{setup} function.

If no \code{setup} function is provided, then \code{nimbleFunction} returns a function that executes the \code{run} function.  It is not a generator in this case, and no other \code{methods} can be provided.

If one wants a generator but does not need any setup arguments or code, \code{setup = TRUE} can be used.

See the NIMBLE User Manual for examples.

For more information about the \code{contains} argument, see the section on nimbleFunctionLists.
}
\author{
NIMBLE development team
}
