% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggPlots.R
\name{survPlot_gg}
\alias{survPlot_gg}
\title{Kaplan-Meier Plot with ggplot2}
\usage{
survPlot_gg(s, CI = "def", pltcens = TRUE, survcl = "gg.def",
  censcl = "red", lty = 1, ltci = 2, shape = 3, bw = FALSE,
  xlab = "Time", ylab = "Survival", main = "")
}
\arguments{
\item{s}{Survival model object, generated by methods like Kaplan-Meier.}

\item{CI}{Type of confidence interval for the survival object.}

\item{pltcens}{Should the plot include the censored values?}

\item{survcl}{Color for observations with outcomes of "survived".}

\item{censcl}{Color for observations with outcomes of "censored".}

\item{lty}{The number of survival curves to be generated from the model.}

\item{ltci}{The number of lines to be generated for confidence intervals.}

\item{shape}{The shapes of points plotted, passed to \code{geom_point}}

\item{bw}{Boolean for desired background color in plots (black/white).}

\item{xlab}{A label for the x-axis, defaults to "Time".}

\item{ylab}{A label for the y-axis, defaults to "Survival".}

\item{main}{A main label for the survival plot, no default.}
}
\description{
Produce a survival plot of a Kaplan-Meier estimator using ggplot2.
}
\examples{
library(survival)
time <- c(5,6,8,3,22)
age <- c(46,35,30,30,36)
drug <- c(0,1,1,1,0)
censor <- c(1,0,1,1,1)
survdat <- as.data.frame(cbind(time, age, drug, censor))
s <- survfit(Surv(survdat$time, survdat$censor) ~ 1, conf.type="none")
survPlot_gg(s)
}

