% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_sigma.R
\name{extract_sigma}
\alias{extract_sigma}
\title{extract \eqn{\Sigma}}
\usage{
extract_sigma(
  data,
  pkg = NULL,
  isotope_a = NULL,
  isotope_b = NULL,
  data_format = NULL
)
}
\arguments{
\item{data}{a \code{list} created by the function \code{niw.post()} or \code{siberMVN()}
in the package
\href{https://cran.r-project.org/package=nicheROVER}{{nicheROVER}}
or \href{https://cran.r-project.org/package=SIBER}{{SIBER}}, respectfully.}

\item{pkg}{a \code{character} string that is the name of the package that
you're using. Defaults to \code{"nicheROVER"}.
Alternatively the user can supply the argument with \code{"SIBER"}.}

\item{isotope_a}{a \code{character} string to change the column name
of the first isotope used in the analysis. Defaults to \code{"d13c"}.}

\item{isotope_b}{a \code{character} string to change the name of second isotope
used in the analysis. Defaults to \code{"d15n"}.}

\item{data_format}{a \code{character} string that decides whether the returned object is
in long or wide format. Default is \code{"wide"}, with the alternative supplied being \code{"long"}.}
}
\value{
Returns a \code{tibble} of extracted estimates of \eqn{\Sigma} created by
the function \code{niw.post()} or \code{siberMVN()} in the packages
\href{https://cran.r-project.org/package=nicheROVER}{{nicheROVER}}.
and \href{https://cran.r-project.org/package=SIBER}{{SIBER}}.

The returned object will contain five columns in the
following order when \code{data_format} is set to \code{"wide"},
\code{metric}, \code{id}, \code{sample_name}, \code{isotope}, \code{sample_number},
and the posterior sample for \eqn{\Sigma} (e.g., \code{d13c} and \code{d15n}).
}
\description{
Extract Bayesian estimates of \eqn{\Sigma} from data objects created by
\href{https://cran.r-project.org/package=nicheROVER}{{nicheROVER}}
or \href{https://cran.r-project.org/package=SIBER}{{SIBER}}.
}
\examples{
extract_sigma(
data = niw_fish_post
)

extract_sigma(
data = post_sam_siber,
pkg = "SIBER"
)

}
\seealso{
\code{\link[nicheROVER:niw.post]{nicheROVER::niw.post()}} and \code{\link[SIBER:siberMVN]{SIBER::siberMVN()}}
}
