% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_similarities.R
\name{extract_similarities}
\alias{extract_similarities}
\title{extract similarities}
\usage{
extract_similarities(data, type = c("bay", "ml"), community_df = NULL)
}
\arguments{
\item{data}{a \code{list} of results from either \code{maxLikOverlap()} or
\code{bayesianOverlap()}.}

\item{type}{description}

\item{community_df}{a four column data frame. One of the columns has to be named
\code{community} and the data in the column will be \code{numeric} as a \code{character}
string(e.g., \verb{"1", "2", "3"}). This is the order of the community names
and will be used to join the actual community names to the correct data.
These are the same class and values required by the function, \code{createSiberObject()}
from \href{https://CRAN.R-project.org/package=SIBER}{{SIBER}}.
The second column will be the names of the groups that are needed to supply
required by the function, \code{createSiberObject()}
from \href{https://CRAN.R-project.org/package=SIBER}{{SIBER}}.
The third and fourth columns contains the actual names of the communities
and groups the user is working with (e.g., \code{"region"}, \code{"common_name"}).}
}
\description{
Extract niche similarities from objects created by \code{{SIBER}}.
}
\examples{
library(purrr)
library(SIBER)

# ---- create community names data frame ----
# uncomment to use
# str(demo.siber.data.2)

demo.siber.data.2$group_name <- as.factor(demo.siber.data.2$group)

demo.siber.data.2$group <- as.numeric(demo.siber.data.2$group_name) |>
as.character()

demo.siber.data.2$community_name <- as.factor(demo.siber.data.2$community)

demo.siber.data.2$community <- as.numeric(demo.siber.data.2$community_name) |>
as.character()

cg_name <- demo.siber.data.2 |>
dplyr::distinct(community, group, community_name, group_name)

# ---- create comparsions ----
cg_names_within_c <- create_comparisons(cg_name,
                                        comparison = "within")

demo.siber.data.2 <- demo.siber.data.2[,1:4]

siber_example <- createSiberObject(demo.siber.data.2)

ml_within_overlap <- cg_names_within_c |>
map(~ maxLikOverlap(.x$cg_1, .x$cg_2, siber_example,
p.interval = NULL, n = 100), .progress = TRUE)

ml_95_within_com <- extract_similarities(ml_within_overlap, type = "ml",
community_df = cg_name)

}
