% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_network.R
\name{get_UT}
\alias{get_UT}
\title{Navigate Upstream with Tributaries}
\usage{
get_UT(network, comid, distance = NULL)
}
\arguments{
\item{network}{data.frame NHDPlus flowlines including at a minimum:
COMID, Pathlength, LENGTHKM, and Hydroseq.}

\item{comid}{integer Identifier to start navigating from.}

\item{distance}{numeric distance in km to limit how many COMIDs are
returned. The COMID that exceeds the distance specified is returned.}
}
\value{
integer vector of all COMIDs upstream with tributaries of the
starting COMID.
}
\description{
Traverse NHDPlus network upstream with tributaries
}
\examples{
library(sf)
source(system.file("extdata", "sample_flines.R", package = "nhdplusTools"))
plot(sample_flines$geom)
start_COMID <- 11690196
UT_COMIDs <- get_UT(sample_flines, start_COMID)
plot(dplyr::filter(sample_flines, COMID \%in\% UT_COMIDs)$geom,
     col = "red", add = TRUE)

UT_COMIDs <- get_UT(sample_flines, start_COMID, distance = 50)
plot(dplyr::filter(sample_flines, COMID \%in\% UT_COMIDs)$geom,
     col = "blue", add = TRUE)

}
