% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_nldi.R
\name{get_nldi_basin}
\alias{get_nldi_basin}
\title{Get NLDI Basin Boundary}
\usage{
get_nldi_basin(nldi_feature, simplify = TRUE, split = FALSE)
}
\arguments{
\item{nldi_feature}{list with names `featureSource` and `featureID` where
`featureSource` is derived from the "source" column of  the response of
dataRetrieval::get_nldi_sources() and the `featureID` is a known identifier
from the specified `featureSource`.}

\item{simplify}{logical should response geometry be simplified for
visualization and performance?}

\item{split}{logical should response resolve precisely to the location
of the `nldi_feature`? Setting `TRUE` calls an aditional service and
will be slower and less robust.}
}
\value{
sf data.frame with result basin boundary
}
\description{
Get a basin boundary for a given NLDI feature.
}
\details{
Only resolves to the nearest NHDPlus catchment divide. See:
https://waterdata.usgs.gov/blog/nldi-intro/ for more info on the nldi.
}
\examples{
\donttest{
library(sf)
library(dplyr)

nldi_nwis <- list(featureSource = "nwissite", featureID = "USGS-05428500")

site <- get_nldi_feature(nldi_nwis)

basin <- get_nldi_basin(nldi_feature = nldi_nwis)

plot(st_geometry(basin))

basin

basin2 <- get_nldi_basin(nldi_feature = nldi_nwis,
                         simplify = FALSE, split = TRUE)

length(st_coordinates(basin))
length(st_coordinates(basin2))

plot(st_geometry(st_buffer(site, units::set_units(3000, "m"))), border = NA)

plot(st_geometry(site), add = TRUE)
plot(st_geometry(basin2), add = TRUE)

plot(st_geometry(basin), border = "red", add = TRUE)

}
}
