% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EIGENnet.R
\name{EIGENnet}
\alias{EIGENnet}
\title{EIGENnet}
\usage{
EIGENnet(qgraph_net, EIGENadj = NULL, S = 1000, burn = 200, seed = 1,
  ...)
}
\arguments{
\item{qgraph_net}{an object of type \code{qgraph}}

\item{EIGENadj}{to use a base matrix for the eigenmodel other than the adjacency matrix
stored in \code{qgraph_net}, provide it in this argument}

\item{S}{number of samples from the Markov chain}

\item{burn}{number of initial scans of the Markov chain to be dropped}

\item{seed}{a random seed}

\item{...}{additional arguments passed to \code{eigenmodel::eigenmodel_mcmc}}
}
\description{
Convenience function for converting a qgraph object to an eigenmodel layout
}
\details{
An eigenmodel can be interpreted based on coordinate placement
of each node. A node in the top right corner scored high on both the first and second
latent components
}
\references{
Jones, P. J., Mair, P., & McNally, R. J. (2017). Scaling networks for two-dimensional visualization: a tutorial. Retrieved from osf.io/eugsz
}
