% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/killworth.R
\name{killworth}
\alias{killworth}
\title{Fit Killworth models to ARD. This function estimates the degrees and
population sizes using the plug-in MLE and MLE estimator.}
\usage{
killworth(
  ard,
  known_sizes = NULL,
  known_ind = 1:length(known_sizes),
  N = NULL,
  model = c("MLE", "PIMLE")
)
}
\arguments{
\item{ard}{The `n_i x n_k` matrix of non-negative ARD integer responses,
where the `(i,k)th` element corresponds to the number of people that
respondent `i` knows in subpopulation `k`.}

\item{known_sizes}{The known subpopulation sizes corresponding to a subset of
the columns of \code{ard}.}

\item{known_ind}{The indices that correspond to the columns of \code{ard}
with known_sizes. By default, the function assumes the first \code{n_known}
columns, where \code{n_known} corresponds to the number of
\code{known_sizes}.}

\item{N}{The known total population size.}

\item{model}{A character string corresponding to either the plug-in MLE
(PIMLE) or the MLE (MLE). The function assumes MLE by default.}
}
\value{
A named list with the estimated degrees and sizes.
}
\description{
Fit Killworth models to ARD. This function estimates the degrees and
population sizes using the plug-in MLE and MLE estimator.
}
\examples{
# Analyze an example ard data set using the killworth function
data(example_data)

ard = example_data$ard
subpop_sizes = example_data$subpop_sizes
N = example_data$N

mle.est = killworth(ard,
known_sizes = subpop_sizes[c(1, 2, 4)],
known_ind = c(1, 2, 4),
N = N, model = "MLE")

pimle.est = killworth(ard,
known_sizes = subpop_sizes[c(1, 2, 4)],
known_ind = c(1, 2, 4),
N = N, model = "PIMLE")

## Compare estimates with the truth
plot(mle.est$degrees, example_data$degrees)

data.frame(true = subpop_sizes[c(3, 5)],
mle = mle.est$sizes,
pimle = pimle.est$sizes)
}
\references{
Killworth, P. D., Johnsen, E. C., McCarty, C., Shelley, G. A.,
  and Bernard, H. R. (1998). A Social Network Approach to Estimating
  Seroprevalence in the United States, \emph{Social Networks}, \bold{20},
  23--50

  Killworth, P. D., McCarty, C., Bernard, H. R., Shelley, G. A., and Johnsen,
  E. C. (1998). Estimation of Seroprevalence, Rape and Homelessness in the
  United States Using a Social Network Approach, \emph{Evaluation Review},
  \bold{22}, 289--308

  Laga, I., Bao, L., and Niu, X. (2021). Thirty Years of the Network Scale-up
  Method, \emph{Journal of the American Statistical Association},
  \bold{116:535}, 1548--1559
}
