% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/attribute_methods.R
\name{get.vertex.attribute.networkLite}
\alias{get.vertex.attribute.networkLite}
\alias{set.vertex.attribute.networkLite}
\alias{list.vertex.attributes.networkLite}
\alias{get.network.attribute.networkLite}
\alias{set.network.attribute.networkLite}
\alias{list.network.attributes.networkLite}
\alias{get.edge.attribute.networkLite}
\alias{get.edge.value.networkLite}
\alias{set.edge.attribute.networkLite}
\alias{set.edge.value.networkLite}
\alias{list.edge.attributes.networkLite}
\alias{delete.vertex.attribute.networkLite}
\alias{delete.edge.attribute.networkLite}
\alias{delete.network.attribute.networkLite}
\title{\code{networkLite} Attribute Methods}
\usage{
\method{get.vertex.attribute}{networkLite}(x, attrname, ..., null.na = TRUE, unlist = TRUE)

\method{set.vertex.attribute}{networkLite}(
  x,
  attrname,
  value,
  v = seq_len(network.size(x)),
  ...,
  upcast = FALSE
)

\method{list.vertex.attributes}{networkLite}(x, ...)

\method{get.network.attribute}{networkLite}(x, attrname, ..., unlist = FALSE)

\method{set.network.attribute}{networkLite}(x, attrname, value, ...)

\method{list.network.attributes}{networkLite}(x, ...)

\method{get.edge.attribute}{networkLite}(x, attrname, ..., null.na = FALSE, unlist = TRUE)

\method{get.edge.value}{networkLite}(x, attrname, ..., null.na = FALSE, unlist = TRUE)

\method{set.edge.attribute}{networkLite}(
  x,
  attrname,
  value,
  e = seq_len(network.edgecount(x, na.omit = FALSE)),
  ...,
  upcast = FALSE
)

\method{set.edge.value}{networkLite}(
  x,
  attrname,
  value,
  e = seq_len(network.edgecount(x, na.omit = FALSE)),
  ...,
  upcast = FALSE
)

\method{list.edge.attributes}{networkLite}(x, ...)

\method{delete.vertex.attribute}{networkLite}(x, attrname, ...)

\method{delete.edge.attribute}{networkLite}(x, attrname, ...)

\method{delete.network.attribute}{networkLite}(x, attrname, ...)
}
\arguments{
\item{x}{A \code{networkLite} object.}

\item{attrname}{The name of an attribute in \code{x}; must be a length one
character vector.}

\item{...}{additional arguments}

\item{null.na}{Logical. If \code{TRUE}, replace \code{NULL} attribute values
with \code{NA} in \code{get.vertex.attribute} and
\code{get.edge.attribute}. Applied before the \code{unlist} argument.
Note that the behavior of \code{null.na} in \code{network} is
somewhat different.}

\item{unlist}{Logical. In \code{get.vertex.attribute} and
\code{get.edge.attribute}, if \code{unlist} is \code{TRUE}, we call
\code{unlist} on the attribute value before returning it, and if
\code{unlist} is \code{FALSE}, we call \code{as.list} on the
attribute value before returning it. In \code{get.network.attribute},
if \code{unlist} is \code{TRUE}, we call \code{unlist} on the
attribute value before returning it, and if \code{unlist} is
\code{FALSE}, we return the attribute value without any modification.}

\item{value}{The attribute value to set in vertex, edge, and network
attribute setters. For \code{set.vertex.attribute} and
\code{set.edge.attribute}, \code{value} should be either an atomic
vector or a list, of length equal to that of \code{v} or \code{e}.
For \code{set.edge.value}, it should be an \code{n} by \code{n}
matrix where \code{n} is the network size of \code{x}.}

\item{v}{Indices at which to set vertex attribute values.}

\item{upcast}{Logical. Are we allowed to upcast atomic types when setting
vertex or edge attribute values on the \code{networkLite}? Setting
\code{upcast = FALSE} prevents upcasting, while setting
\code{upcast = TRUE} allows but does not guarantee upcasting.}

\item{e}{Indices at which to set edge attribute values.}
}
\value{
Behavior and return values are analogous to those of the
corresponding \code{network} methods, with network data structured
in the \code{networkLite} format.
}
\description{
S3 attribute methods for the \code{networkLite} class, for
generics defined in the \code{network} package.
}
\details{
Allows basic attribute manipulation for \code{networkLite}s. Note
that an edge or vertex attribute not present in the
\code{networkLite} is treated as a list of \code{NULL}s of length
equal to the number of edges or vertices (respectively) before
applying the \code{null.na} and \code{unlist} arguments.
}
