% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_netmhc2pan_data_url.R
\name{check_netmhc2pan_data_url}
\alias{check_netmhc2pan_data_url}
\title{Check the URL of the NetMHCIIpan binary tarball}
\usage{
check_netmhc2pan_data_url(
  netmhc2pan_data_url = get_netmhc2pan_data_url(),
  verbose = FALSE,
  temp_local_file = tempfile(pattern = "check_netmhc2pan_data_url_")
)
}
\arguments{
\item{netmhc2pan_data_url}{URL to download the
NetMHCIIpan data tarball file from,
similar to, for example,
\url{https://www.cbs.dtu.dk/services/NetMHCIIpan-3.2/data.Linux.tar.gz}.
Use \link{get_netmhc2pan_data_url} to get the default URL.}

\item{verbose}{set to TRUE for more output}

\item{temp_local_file}{path to the temporary file to store the URL to.
This file will be deleted afterwards.}
}
\description{
Check the URL of the NetMHCIIpan binary tarball is valid,
will stop if not.
This URL link expires after 4 hours.
}
