% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createC.R
\name{createC}
\alias{createC}
\alias{createC.matrix}
\alias{createC.netcomb}
\alias{createC.netmeta}
\alias{createC.netconnection}
\alias{createC.default}
\alias{combinations}
\title{Auxiliary functions for component network meta-analysis}
\usage{
createC(x, ...)

\method{createC}{matrix}(
  x,
  comb.ia,
  inactive = NULL,
  sep.comps = gs("sep.comps"),
  sep.ia = gs("sep.ia"),
  ...
)

\method{createC}{netcomb}(x, comb.ia = NULL, inactive = NULL, sep.ia = x$sep.ia, ...)

\method{createC}{netmeta}(x, inactive = NULL, sep.comps = gs("sep.comps"), ...)

\method{createC}{netconnection}(x, inactive = NULL, sep.comps = gs("sep.comps"), ...)

\method{createC}{default}(x, n = 1, ...)

combinations(x, n = NULL)
}
\arguments{
\item{x}{A \code{\link{netcomb}}, \code{\link{netmeta}} or
\code{\link{netconnection}} object, a matrix or the number of components.}

\item{\dots}{Additional arguments.}

\item{comb.ia}{A character vector specifying treatment combinations which
will be considered as interactions.}

\item{inactive}{A character string defining the inactive treatment
component (see \code{\link{netcomb}}).}

\item{sep.comps}{A single character to define separator between
treatment components.}

\item{sep.ia}{A single character to define separator for interactions.}

\item{n}{A single number specifying the number of components in combinations.}
}
\value{
R function \code{createC} returns a combination matrix / C matrix with
studies in rows and component and interaction terms in columns.

R function \code{combinations} returns a character vector with combinations.
}
\description{
Auxiliary functions to (i) create a combination / C matrix with information
on treatment combinations and interaction terms and (ii) a vector with all
combinations in a component network meta-analysis.
}
\examples{
data(Linde2016)

# Only consider studies including Face-to-face PST (to reduce
# runtime of example)
#
face <- subset(Linde2016, id \%in\% c(16, 24, 49, 118))

# Conduct random effects network meta-analysis
#
net1 <- netmeta(lnOR, selnOR, treat1, treat2, id,
  data = face, ref = "placebo", sm = "OR", common = FALSE)

# Additive component network meta-analysis (with placebo as inactive
# treatment)
#
nc1 <- netcomb(net1, inactive = "placebo")

# Available combinations in CNMA
combinations(nc1)

# Create C matrix with all available interactions, i.e., one interaction
# for each combination
createC(nc1)

# Run interaction CNMA model with all available interactions
# (same result as standard NMA)
netcomb(net1, C.matrix = createC(nc1))

\dontrun{
# Conduct random effects network meta-analysis on full dataset
#
net2 <- netmeta(lnOR, selnOR, treat1, treat2, id,
  data = Linde2016, ref = "placebo", sm = "OR", common = FALSE)

# Additive component network meta-analysis (with placebo as inactive
# treatment)
#
nc2 <- netcomb(net2, inactive = "placebo")

# Available combinations in CNMA
combinations(nc2)

# Create C matrix with all available interactions, i.e., one interaction
# for each combination
head(createC(nc2))

# Run interaction CNMA model with all available interactions
# (same result as standard NMA)
netcomb(net2, C.matrix = createC(nc2))
}

}
\seealso{
\code{\link{netcomb}}, \code{\link{discomb}}
}
\author{
Guido Schwarzer \email{guido.schwarzer@uniklinik-freiburg.de},
  Gerta Rücker \email{gerta.ruecker@uniklinik-freiburg.de}
}
