% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hatmatrix.R
\name{hatmatrix}
\alias{hatmatrix}
\alias{print.hatmatrix}
\title{Derive hat matrix from network meta-analysis}
\usage{
hatmatrix(
  x,
  method = "Ruecker",
  type,
  common = x$common,
  random = x$random,
  nchar.trts = x$nchar.trts,
  nchar.studlab = x$nchar.studlab
)

\method{print}{hatmatrix}(
  x,
  common = x$x$common,
  random = x$x$random,
  nchar.trts = x$x$nchar.trts,
  nchar.studlab = x$x$nchar.studlab,
  digits = gs("digits"),
  legend = TRUE,
  legend.studlab = TRUE,
  ...
)
}
\arguments{
\item{x}{A \code{\link{netmeta}} object.}

\item{method}{A character string indicating which method is used to
derive the hat matrix. Either \code{"Ruecker"}, \code{"Krahn"} or
\code{"Davies"} (can be abbreviated, see Details).}

\item{type}{A character string indicating which specific hat matrix
should be derived (can be abbreviated, see Details).}

\item{common}{A logical indicating whether a hat matrix should be
printed for the common effects network meta-analysis.}

\item{random}{A logical indicating whether a hat matrix should be
printed for the random effects network meta-analysis.}

\item{nchar.trts}{A numeric defining the minimum number of
characters used to create unique treatment names.}

\item{nchar.studlab}{A numeric defining the minimum number of
characters used to create unique study labels.}

\item{digits}{Minimal number of significant digits, see
\code{print.default}.}

\item{legend}{A logical indicating whether a legend should be
printed.}

\item{legend.studlab}{A logical indicating whether a legend should
be printed for abbreviated study labels.}

\item{\dots}{Additional arguments (ignored).}
}
\value{
A list with two hat matrices: \code{common} (common effects model)
and \code{random} (random effects model).
}
\description{
Auxiliary function to derive hat matrix from network meta-analysis
}
\details{
This auxiliary function can be used to derive various hat matrices
from a network meta-analysis object.

\subsection{Hat matrix by Rücker (2012)}{

This hat matrix is estimated if \code{method = "Ruecker"}.

Let \emph{n} be the number of different treatments (nodes,
vertices) in a network and let \emph{m} be the number of existing
comparisons (edges) between the treatments. If there are only
two-arm studies, \emph{m} is equal to the number of studies,
\emph{k}. Let seTE.adj.common and seTE.adj.random be the vectors of
adjusted standard errors under the common and random effects model
(see \code{\link{netmeta}}). Let \strong{W} be the \emph{m} x
\emph{m} diagonal matrix that contains the inverse variance 1 /
seTE.adj.common\eqn{^2} or 1 / seTE.adj.random\eqn{^2}.

The given comparisons define the network structure. Therefrom an
\emph{m} x \emph{n} design matrix X (edge-vertex incidence matrix) is
formed; for more precise information, see Rücker (2012). Moreover,
the \emph{n} x \emph{n} Laplacian matrix \strong{L} and its
Moore-Penrose pseudoinverse \strong{L}\eqn{^+} are calculated (both
matrices play an important role in graph theory and electrical
network theory). Using these matrices, the variances based on both
direct and indirect comparisons can be estimated. The hat matrix
\strong{H} is estimated by \strong{H =
XL}\eqn{^+}\strong{X}\eqn{^T}\strong{W = X(X}\eqn{^T}\strong{W
X)}\eqn{^+}\strong{X}\eqn{^T}\strong{W}.
}

\subsection{Hat matrices by Krahn et al. (2013)}{

One of the following hat matrices is estimated if \code{method
= "Krahn"}.

Use of \code{type = "design"} (default) results in a hat matrix of
dimension \emph{n(n-1)/2} x \emph{s}, where \emph{s} is the sum of
the number of independent comparisons from each design.

Use of \code{type = "studies"} results in a hat matrix of dimension
\emph{n(n-1)/2} x \emph{l}, where \emph{l} is the number of
independent pairwise comparisons, i.e., a three-arm study
contributes two pairwise comparisons.
}

\subsection{Hat matrices by Davies et al. (2022)}{

One of three hat matrices is estimated if \code{method = "Davies"}.

Here, we focus on the hat matrix of the aggregate (two-step)
version of the graph theoretical NMA model. In the first step, a
pairwise meta-analysis is performed across each edge using the
adjusted weights (these account for correlations due to multi-arm
trials). From this we obtain direct treatment effect estimates (and
corresponding aggregate weights) associated with each edge. In step
two, we combine these direct estimates in a network meta analysis
to obtain the network estimates.  This is done using weighted least
squares regression. The hat matrix associated with this second step
is called the \emph{aggregate hat matrix}.

All three versions of the aggregate hat matrix contain the same
information: the second two can be derived directly from the
first. They differ in their dimensionality.

Each row of the hat matrix that represents a treatment comparison
(\emph{ij}) describes the flow of evidence through each edge for
that comparison. This defines a directed acyclic 'flow graph' from
node \emph{i} to node \emph{j}.

(1) Use of \code{type = "short"} (default) results in a hat matrix
of dimension \emph{e} x \emph{e}, where \emph{e} is the number of
(unique) edges (direct comparisons) in the network. This is the
aggregate hat matrix described in Davies et al. (2022). Each row
and column represents a pair of treatments for which there is at
least one direct comparison.

(2) Use of \code{type = "long"} results in a hat matrix of
dimension \emph{n(n-1)/2} x \emph{e}. There is a row for every
possible pair of treatments in the network - regardless of whether
there is direct evidence for this comparison. Each column
represents a pair of treatments for which there is at least one
direct comparison. The extra rows can be calculated from the short
hat matrix using consistency equations.


(3) Use of \code{type = "full"} results in a hat matrix of
dimension \emph{n(n-1)/2} x \emph{n(n-1)/2}. In comparison to the
long hat matrix, columns of zeroes are added for comparisons that
do not have any direct evidence. Therefore, there is a row and
column for every pair of treatments in the network. This hat matrix
is used to calculate the transition matrices for the random walk in
\code{\link{netcontrib}}.
}
}
\examples{
data(Dong2013)
# Only consider first ten studies for concise output
first10 <- subset(Dong2013, id <= 10)
p1 <- pairwise(treatment, death, randomized, studlab = id,
  data = first10, sm = "OR")
net1 <- netmeta(p1, common = FALSE)

hatmatrix(net1)
hatmatrix(net1, method = "k")
hatmatrix(net1, method = "k", type = "studies")
hatmatrix(net1, method = "d")
hatmatrix(net1, method = "d", type = "long")
hatmatrix(net1, method = "d", type = "full")

}
\references{
Davies AL, Papakonstantinou T, Nikolakopoulou A, Rücker G, Galla T
(2022):
Network meta-analysis and random walks.
\emph{Statistics in Medicine},
\bold{41}, 2091--2114

Krahn U, Binder H, König J (2013):
A graphical tool for locating inconsistency in network meta-analyses.
\emph{BMC Medical Research Methodology},
\bold{13}, 35

Rücker G (2012):
Network meta-analysis, electrical networks and graph theory.
\emph{Research Synthesis Methods},
\bold{3}, 312--24
}
\seealso{
\code{\link{netmeta}}, \code{\link{netcontrib}},
  \code{\link{netheat}}
}
\author{
Guido Schwarzer \email{guido.schwarzer@uniklinik-freiburg.de}
}
