% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/joinTableNEON.R
\name{joinTableNEON}
\alias{joinTableNEON}
\title{Join two data tables from NEON Observational System}
\usage{
joinTableNEON(
  table1,
  table2,
  name1 = NA_character_,
  name2 = NA_character_,
  location.fields = NA
)
}
\arguments{
\item{table1}{A data frame containing data from a NEON observational data table [data frame]}

\item{table2}{A second data frame containing data from a NEON observational data table [data frame]}

\item{name1}{The name of the first table. Defaults to the object name of table1. [character]}

\item{name2}{The name of the second table. Defaults to the object name of table2. [character]}

\item{location.fields}{Should standard location fields be included in the list of linking variables, to avoid duplicating those fields? For most data products, these fields are redundant, but there are a few exceptions. This parameter defaults to NA, in which case the Quick Start Guide is consulted. If QSG indicates location fields shouldn't be included, value is updated to FALSE, otherwise to TRUE. Enter TRUE or FALSE to override QSG defaults. [logical]}
}
\value{
A single data frame created by joining table1 and table2 on the fields identified in the quick start guide.
}
\description{
NEON observational data are published in multiple tables, usually corresponding to activities performed in different times or places. This function uses the fields identified in NEON Quick Start Guides to join tables containing related data.
}
\details{
The "Table joining" section of NEON Quick Start Guides (QSGs) provides the field names of the linking variables between related NEON data tables. This function uses the QSG information to join tables. All tables are joined using a full join. If you need to remove duplicates as well as joining, run removeDups() before running joinTableNEON(). Tables that don't appear together in QSG instructions can't be joined here. Some tables may not be straightforwardly joinable, such as tables of analytical standards run as unknowns. Theoretically, these data could be joined to analytical results by a combination of laboratory and date, but in general, a table join is not the best way to analyze this type of data. If a pair of tables is omitted from QSG instructions that you expected to find, contact NEON.
}
\examples{
# Join metadata from the point level to individual observations, for NEON bird data
all_bird <- joinTableNEON(table1=brd_perpoint, table2=brd_countdata)
}
\references{
License: GNU AFFERO GENERAL PUBLIC LICENSE Version 3, 19 November 2007
}
\author{
Claire Lunch \email{clunch@battelleecology.org}
}
