% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/netsDataFrame.R
\name{netsDataFrame}
\alias{netsDataFrame}
\title{Networks Data Frame}
\usage{
netsDataFrame(net_attr_df, node_attr_df, edge_df,
  cent_measure = c("mean"))
}
\arguments{
\item{net_attr_df}{A data frame consisting of all of the networks' graph
attributes. The first column should contain the name of the network, and 
all other columns should be numeric. All empty entries should be filled as
"NA".}

\item{node_attr_df}{A data frame consisting of all of the networks' nodes'
attributes. All columns should be numeric. All empty entries should be 
filled in as "NA".}

\item{edge_df}{A data frame consisting of the edge matrix for each ego
network. Edges are assumed to be undirected and unweighted. 1 indicates the
existence of an edge between nodes, 0 indicates the lack of an edge.}

\item{cent_measure}{A vector of the measures of centrality to be used for the
summary of the node attributes data. The supported measures of centrality
are: "mean" and "median".}
}
\value{
The function returns a data frame that offers an overview of all of
the ego networks.
}
\description{
\code{netsDataFrame} produces data frames of collections of networks.
}
\details{
The function produces data frames of collections of networks. The function
requires the input of three data frames: a data frame containing the graph
attributes, a data frame containing the node characteristics and a data frame
containing the edge list of each network. The rows in each of these data
frames must represent individual  networks, and must therefore have identical
row length. Measures of centrality used in the summarization of the node
attributes must also be furnished.
}
\examples{
df <- netsDataFrame(network_attr_df,
                    node_attr_df,
                    edge_df)
}
\author{
Philippe Boileau, \email{philippe_boileau@berkeley.edu}
}
