% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ncpen_cpp_wrap.R
\name{coef.cv.ncpen}
\alias{coef.cv.ncpen}
\title{Extracts the optimal vector of coefficients from a \code{cv.ncpen} object.}
\usage{
\method{coef}{cv.ncpen}(object, type = c("error", "deviance"), ...)
}
\arguments{
\item{object}{fitted \code{cv.ncpen} object.}

\item{type}{(character) a cross-validated error type which is either "error" or "deviance". Each error type is defined in \code{\link{cv.ncpen}}.}

\item{...}{Other arguments to coef. Not supported.}
}
\value{
the optimal coefficients vector selected by cross-validation method.
}
\description{
This function returns the optimal vector of coefficients.
}
\examples{

s0 = sam.gen.fun(n=100,p=20,q=10,bmin=0.5,bmax=1,corr=0.5,family="binomial", seed = 1234)
x.mat = s0$x.mat
y.vec = s0$y.vec

cvfit = cv.ncpen(y.vec=y.vec, x.mat=x.mat, family="binomial")
coef.cv.ncpen(cvfit, type="deviance")

}
\references{
Kwon, S., Lee, S. and Kim, Y. (2016). Moderately clipped LASSO. \emph{Computational Statistics and Data Analysis}, \bold{92C}, 53-67.
}
\seealso{
\code{\link{cv.ncpen}}, \code{\link{plot.cv.ncpen}}
}
\author{
Dongshin Kim, Sunghoon Kwon, Sangin Lee

Maintainer: Dongshin Kim<dongshin.kim@outlook.com>, Sunghoon Kwon<shkwon0522@gmail.com>
}
