% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nca_ind_data.R
\name{nca_ind_data}
\alias{nca_ind_data}
\title{Prepare individual PK data}
\usage{
nca_ind_data(pkData, dvLog = FALSE, dataType = "obs", idNm = "ID",
  timeNm = "TIME", concNm = "DV", adminType = "extravascular",
  TI = NULL, dateColNm = NULL, dateFormat = NULL,
  timeFormat = "number")
}
\arguments{
\item{pkData}{PK concentration-time data.}

\item{dvLog}{If \code{TRUE} concentration is in logarithmic scale. Default is
\strong{\code{FALSE}}}

\item{dataType}{Indicates if the data is observed ("obs") or simulated 
("sim"). Since the simulated data is assumed to be obtained from NONMEM 
output, DATE and clock time (\code{dateColNm}, \code{dateFormat}, 
\code{timeFormat}) are not used for time data. Default is \strong{"obs"}.}

\item{idNm}{Column name for ID in PK data. Default is \strong{"ID"}}

\item{timeNm}{Column name for time in PK data. Default is 
\strong{"TIME"}}

\item{concNm}{Column name for concentration in PK data. Default is 
\strong{"DV"}}

\item{adminType}{Route of administration. Allowed options are iv-bolus,
iv-infusion or extravascular. Default is \strong{"extravascular"}}

\item{TI}{Infusion duration. If TI is a single numeric value, TI is the same
for all individuals. If TI is the name of a column with numeric data
present in the data set, TI is set to the unique value of the column for a
given individual. Default is \strong{\code{NULL}}}

\item{dateColNm}{column name for date if used (e.g. "Date", "DATE"). Default
is \strong{\code{NULL}}}

\item{dateFormat}{date format (D-M-Y, D/M/Y or any other combination of
D,M,Y). Default is \strong{\code{NULL}}}

\item{timeFormat}{time format (number, H:M, H:M:S). Default is
\strong{"number"}}
}
\value{
A list of objects with time-conc data and individual infusion
  duration for iv-infusion data
}
\description{
Extracts time-conc data for a given individual.
}
\details{
Extracts time-conc data for a given individual.
}
