% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/nca.deviation.plot.R
\name{nca.deviation.plot}
\alias{nca.deviation.plot}
\title{Plot individual deviation of NCA metrics estimated from observed and simulated
data}
\usage{
nca.deviation.plot(plotdata, xvar = NULL, devcol = NULL, figlbl = NULL,
  spread = "pi", cunit = "[M].[L]^-3", tunit = "[T]")
}
\arguments{
\item{plotdata}{A data frame containing the scaled deviation values of the
NCA metrics}

\item{xvar}{x-variable against which the deviation data will be plotted
(\strong{NULL})}

\item{devcol}{column names/numbers of the data frame containing deviation
data (\strong{NULL})}

\item{figlbl}{Figure label based on dose identifier and/or population
stratifier (\strong{NULL})}

\item{spread}{measure of the spread of simulated data (sd or pi (95\%
nonparametric prediction interval)) (\strong{"pi"})}

\item{cunit}{Unit for concentration (\strong{"[M].[L]^-3"})}

\item{tunit}{Unit for time (\strong{"[T]"})}
}
\value{
returns the data frame with the NPDE values based on the input data.
}
\description{
\pkg{nca.deviation.plot} plots individual deviation of selected NCA metrics
estimated from observed and simulated data.
}
\details{
\pkg{nca.deviation.plot} plots individual deviation of selected NCA metrics
estimated from observed and simulated data. This function requires three
mandatory arguments, (i) deviation data, (ii) independent variable and (iii)
dependent variables. The deviation of the NCA metrics values estimated from
the observed and simulated data are scaled by the "spread" of the simulated
metrics values. The "spead" of the simulated data is measured either by the
standard deviation or the 95% nonparametric interval.
}

