% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neuronlistfh.R
\name{write.neuronlistfh}
\alias{write.neuronlistfh}
\title{Write out a neuronlistfh object to an RDS file}
\usage{
write.neuronlistfh(x, file = attr(x, "file"), overwrite = FALSE, ...)
}
\arguments{
\item{x}{The neuronlistfh object to write out}

\item{file}{Path where the file will be written (see details)}

\item{overwrite}{Whether to overwrite an existing file}

\item{\dots}{Additional paramaters passed to \code{saveRDS}}
}
\description{
Write out a neuronlistfh object to an RDS file
}
\details{
This function writes the main neuronlistfh object to disk, but makes
  no attempt to touch/verify the associated object files.
  
  if \code{file} is not specified, then the function will first check if 
  \code{x} has a \code{'file'} attribute. If that does not exist, then 
  \code{attr(x,'db')@dir}, the backing \code{filehash} database directory, 
  is inspected. The save path \code{file} will then be constructed by taking 
  the directory one up from the database directory and using the name of the 
  neuronlistfh object with the suffix '.rds'. e.g. write.neuronlistfh(kcs20) 
  with db directory '/my/path/dps/data' will be saved as 
  '/my/path/dps/kcs20.rds'
  
  Note that if x has a \code{'file'} attribute (set by 
  \code{read.neuronlistfh}) then this will be removed before the file is 
  saved (since the file attribute must be set on read to ensure that we know 
  exactly which file on disk was the source of the object in memory).
}
\seealso{
\code{\link{saveRDS}}

Other neuronlistfh: \code{\link{[.neuronlistfh}},
  \code{\link{neuronlistfh}},
  \code{\link{read.neuronlistfh}}, \code{\link{remotesync}}
}
