% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/neuronlist_sets.R
\name{setdiff}
\alias{setdiff}
\alias{setdiff.default}
\alias{setdiff.neuronlist}
\title{Find the (asymmetric) difference between two collections of objects}
\usage{
setdiff(x, y, ...)

\method{setdiff}{default}(x, y, ...)

\method{setdiff}{neuronlist}(x, y, ...)
}
\arguments{
\item{x}{the first collection to consider.}

\item{y}{the second collection to consider.}

\item{...}{additional arguments passed to methods}
}
\value{
A collection of the same mode as \code{x} that contains all elements
  of \code{x} that are not present in \code{y}.
}
\description{
Find the (asymmetric) difference between two collections of objects
}
\details{
Note that setdiff.default calls base::setdiff to ensure consistent
  behaviour for regular vectors.

  As a convenience \code{setdiff.neuronlist} allows \code{y}, the second
  collection, to be a character vector of names.
}
\seealso{
\code{\link[base]{setdiff}}
}

