% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ifafgwc.R
\name{ifafgwc}
\alias{ifafgwc}
\title{Fuzzy Geographicaly Weighted Clustering with (Intelligent) Firefly Algorithm}
\usage{
ifafgwc(
  data,
  pop = NA,
  distmat = NA,
  ncluster = 2,
  m = 2,
  distance = "euclidean",
  order = 2,
  alpha = 0.7,
  a = 1,
  b = 1,
  error = 1e-05,
  max.iter = 100,
  randomN = 0,
  vi.dist = "uniform",
  ei.distr = "normal",
  fa.same = 10,
  nfly = 10,
  ffly.no = 2,
  ffly.dist = "euclidean",
  ffly.order = 2,
  gamma = 1,
  ffly.beta = 1,
  ffly.alpha = 1,
  r.chaotic = 4,
  m.chaotic = 0.7,
  ind.levy = 1,
  skew.levy = 0,
  scale.levy = 1,
  ffly.alpha.type = 4
)
}
\arguments{
\item{data}{an object of data with d>1. Can be \code{matrix} or \code{data.frame}. If your data is univariate, bind it with \code{1} to get a 2 columns.}

\item{pop}{an n*1 vector contains population.}

\item{distmat}{an n*n distance matrix between regions.}

\item{ncluster}{an integer. The number of clusters.}

\item{m}{degree of fuzziness or fuzzifier. Default is 2.}

\item{distance}{the distance metric between data and centroid, the default is euclidean, see \code{\link{cdist}} for details.}

\item{order, }{minkowski order. default is 2.}

\item{alpha}{the old membership effect with [0,1], if \code{alpha} equals 1, it will be same as fuzzy C-Means, if 0, it equals to neighborhood effect.}

\item{a}{spatial magnitude of distance. Default is 1.}

\item{b}{spatial magnitude of population. Default is 1.}

\item{error}{error tolerance. Default is 1e-5.}

\item{max.iter}{maximum iteration. Default is 500.}

\item{randomN}{random seed for initialisation (if uij or vi is NA). Default is 0.}

\item{vi.dist}{a string of centroid population distribution between \code{'uniform'} (default) and \code{'normal'}. Can be defined as \code{vi.dist=} in \code{opt_param}.}

\item{ei.distr}{distribution of random walk parameter. Can be defined as \code{ei.distr} in \code{opt_param}.}

\item{fa.same}{number of consecutive unchange to stop the iteration. Can be defined as \code{same=} in \code{opt_param}.}

\item{nfly}{number of fireflies. Can be defined as \code{npar=} in \code{opt_param}. Default is 10.}

\item{ffly.no}{The number of selected best fireflies for intelligent firefly algorithm. Can be defined as \code{par.no=} in \code{opt_param}. Default is 2}

\item{ffly.dist}{The distance between fireflies. Can be defined as \code{par.dist=} in \code{opt_param}. Default is \code{'euclidean'},}

\item{ffly.order}{The minkowski order of the \code{par.dist} if \code{par.dist='minkowski'}. Can be defined as \code{par.order=} in \code{opt_param}. Default is 2}

\item{gamma}{distance scaling factor. Can be defined as \code{gamma} in \code{opt_param}. Default is 1.}

\item{ffly.beta}{Attractiveness constant. Can be defined as \code{beta} in \code{opt_param}. Default is 1.}

\item{ffly.alpha}{Randomisation constant. Can be defined as \code{alpha=} in \code{opt_param}.}

\item{r.chaotic}{weight in logistic chaotic between [0,4]. Can be used when \code{ei.distr='logchaotic'}. Can be defined as \code{chaos} in \code{opt_param}. Default is 4.}

\item{m.chaotic}{mapping parameter in kent chaotic between [0,1]. Can be used when \code{ei.distr='kentchaotic'}. Can be defined as \code{map} in \code{opt_param}. Default is 0.7.}

\item{ind.levy}{Levy distribution index for random walk. Can be used when \code{ei.distr='levy'}. Can be defined as \code{ind} in \code{opt_param}. Default is 1.}

\item{skew.levy}{Levy distribution skewness for random walk. Can be used when \code{ei.distr='levy'}. Can be defined as \code{skew} in \code{opt_param}. Default is 0.}

\item{scale.levy}{Levy distribution scale for random walk. Can be used when \code{ei.distr='levy'}. Can be defined as \code{sca} in \code{opt_param}. Default is 1.}

\item{ffly.alpha.type}{An integer. The type of \code{ffly.alpha} update. Can be selected from 1 to 5. Can be defined as \code{update_type} in \code{opt_param}. Default is 4.}
}
\value{
an object of class \code{'fgwc'}.\cr
An \code{'fgwc'} object contains as follows:
\itemize{
\item \code{converg} - the process convergence of objective function
\item \code{f_obj} - objective function value
\item \code{membership} - membership matrix
\item \code{centroid} - centroid matrix
\item \code{validation} - validation indices (there are partition coefficient (\code{PC}), classification entropy (\code{CE}), 
SC index (\code{SC}), separation index (\code{SI}), Xie and Beni's index (\code{XB}), IFV index (\code{IFV}), and Kwon index (Kwon))
\item \code{max.iter} - Maximum iteration
\item \code{cluster} - the cluster of the data
\item \code{finaldata} - The final data (with the cluster)
\item \code{call} - the syntax called previously
\item \code{time} - computational time.
}
}
\description{
Fuzzy clustering with addition of spatial configuration of membership matrix with centroid optimization using (Intelligent) Firefly Algorithm.
}
\details{
Fuzzy Geographically Weighted Clustering (FGWC) was developed by \insertCite{fgwc;textual}{naspaclust} by adding 
neighborhood effects and population to configure the membership matrix in Fuzzy C-Means. Furthermore,
the Firefly Algorithm was developed by \insertCite{Yang2009;textual}{naspaclust} and the technique is also upgraded by 
\insertCite{intfa;textual}{naspaclust} by adding the intelligent phase (choosing the best firefly based on the intensity) in order to get a more optimal
solution of a certain complex function. FGWC using IFA has been implemented previously by \insertCite{Nasution2020;textual}{naspaclust}.
}
\examples{
data('census2010')
data('census2010dist')
data('census2010pop')
# First way
res1 <- ifafgwc(census2010,census2010pop,census2010dist,3,2,'minkowski',4,nfly=10)
# Second way
# initiate parameter
param_fgwc <- c(kind='v',ncluster=3,m=2,distance='minkowski',order=3,
               alpha=0.5,a=1.2,b=1.2,max.iter=1000,error=1e-6,randomN=10)
## tune the IFA parameter
ifa_param <- c(vi.dist='uniform', ei.distr='logchaotic',
					fa.same=10, npar=15, par.no=3, par.dist='minkowski', 
           par.order=4, gamma=1, beta=1.5,
           alpha=1, chaos=4,update_type=4) 
##FGWC with IFA
res2 <- fgwc(census2010,census2010pop,census2010dist,'ifa',param_fgwc,ifa_param)
}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{fpafgwc}} \code{\link{gsafgwc}}
}
