% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find.R
\name{get_team_info}
\alias{get_team_info}
\title{Enhanced Get Team Info with Smart Matching}
\usage{
get_team_info(team, series = "all", type = "summary", interactive = TRUE)
}
\arguments{
\item{team}{Character string of team name to search for}

\item{series}{Either character string ("cup", "xfinity", "truck", "all") or data frame}

\item{type}{Character string specifying return type ("summary", "season", "all")}

\item{interactive}{Logical. Is the session interactive?}
}
\value{
Tibble with team statistics or NULL if no exact match
}
\description{
Enhanced Get Team Info with Smart Matching
}
\examples{
\dontrun{
# Get Joe Gibbs Racing career summary
get_team_info("Joe Gibbs Racing")

# Handle partial name - will prompt for selection
get_team_info("joe gib racing")
# Found 1 teams matching 'joe gib racing':
#  1 - Joe Gibbs Racing
# Select team number: 1
# Team: Joe Gibbs Racing
# Returns summary table

# Get season-by-season data for Cup series only
get_team_info("Joe Gibbs Racing", series = "cup", type = "season")
}
}
