% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nasapower-package.R
\docType{package}
\name{nasapower-package}
\alias{nasapower}
\alias{nasapower-package}
\title{nasapower: NASA POWER API Client}
\description{
\if{html}{\figure{logo.png}{options: style='float: right' alt='logo' width='120'}}

An API client for NASA POWER global meteorology, surface solar energy and climatology data API. POWER (Prediction Of Worldwide Energy Resources) data are freely available for download with varying spatial resolutions dependent on the original data and with several temporal resolutions depending on the POWER parameter and community. This work is funded through the NASA Earth Science Directorate Applied Science Program. For more on the data themselves, the methodologies used in creating, a web- based data viewer and web access, please see \url{https://power.larc.nasa.gov/}.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://docs.ropensci.org/nasapower/}
  \item Report bugs at \url{https://github.com/ropensci/nasapower/issues}
}

}
\author{
\strong{Maintainer}: Adam H. Sparks \email{adamhsparks@gmail.com} (\href{https://orcid.org/0000-0002-0061-8359}{ORCID})

Other contributors:
\itemize{
  \item Scott Chamberlain \email{myrmecocystus@gmail.com} (\href{https://orcid.org/0000-0003-1444-9135}{ORCID}) (Scott Chamberlain reviewed nasapower for rOpenSci, see
 <https://github.com/ropensci/software-review/issues/155>.) [reviewer]
  \item Hazel Kavili (Hazel Kavili reviewed nasapower for rOpenSci, see
 <https://github.com/ropensci/software-review/issues/155>.) [reviewer]
  \item Alison Boyer (Alison Boyer reviewed nasapower for rOpenSci, see
 <https://github.com/ropensci/software-review/issues/155>.) [reviewer]
  \item Fernando Miguez \email{femiguez@iastate.edu} (\href{https://orcid.org/0000-0002-4627-8329}{ORCID}) (Fernando Miguez provided assistance in identifying
 improper missing value handling in the POWER data, see 
 <https://github.com/femiguez/apsimx/pull/26>.) [contributor]
  \item Maëlle Salmon (\href{https://orcid.org/0000-0002-2815-0399}{ORCID}) (Maëlle Salmon contributed a patch to fix issues with using the R
 package, 'vcr', for testing the API queries, see
 <https://github.com/ropensci/nasapower/pull/64>.) [contributor]
  \item Phillip D. Alderman \email{phillip.alderman@okstate.edu} (\href{https://orcid.org/0000-0003-1467-2337}{ORCID}) (Phillip Alderman contributed a patch to fix an issue with, 'The
 `file` argument of `vroom()` must use `I()` for literal data as
 of vroom 1.5.0.', see
 <https://github.com/ropensci/nasapower/pull/67>.) [contributor]
  \item Aleksandar Blagotić \email{alex@rapporter.net} (Author of the CRAN package 'rapportools', from which
 the '.is_boolean()' was taken.) [contributor]
  \item Gergely Daróczi \email{daroczig@rapporter.net} (Author of the CRAN package 'rapportools', from which
 the '.is_boolean()' was taken.) [contributor]
  \item Curtin University (Supported the development of 'nasapower' through Adam H.
 Sparks' time.) [copyright holder]
}

}
\keyword{internal}
