% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vtrack.R
\name{emr_vtrack.ls}
\alias{emr_vtrack.ls}
\title{Returns a list of virtual track names}
\usage{
emr_vtrack.ls(
  pattern = "",
  ignore.case = FALSE,
  perl = FALSE,
  fixed = FALSE,
  useBytes = FALSE
)
}
\arguments{
\item{pattern, ignore.case, perl, fixed, useBytes}{see 'grep'}
}
\value{
An array that contains the names of virtual tracks.
}
\description{
Returns a list of virtual track names.
}
\details{
This function returns a list of virtual tracks that exist in current R
environment that match the pattern (see 'grep'). If called without any
arguments all virtual tracks are returned.
}
\examples{

emr_db.init_examples()
emr_vtrack.create("vtrack1", "dense_track", func = "max")
emr_vtrack.create("vtrack2", "dense_track", func = "min")
emr_vtrack.ls()
emr_vtrack.ls("*2")
}
\seealso{
\code{\link{grep}}, \code{\link{emr_vtrack.exists}},
\code{\link{emr_vtrack.create}}, \code{\link{emr_vtrack.rm}}
}
\keyword{~ls}
\keyword{~virtual}
