
has.interaction <- function(x,terms){
  #####################################
  # Automated model selection
  # Author      : Joris Meys
  # version     : 0.2
  # date        : 12/01/09
  #####################################
  #CHANGE LOG
  # 0.2   : check for empty scopevar vector
  #####################################

  # Function has.interaction checks whether x is part of a term in terms
  # terms is a vector with names of terms from a model
  out <- sapply(terms,function(i){
    sum(1-(strsplit(x,":")[[1]] %in% strsplit(i,":")[[1]]))==0
  })
  return(sum(out)>0)
}

#'@importFrom stats as.formula drop1  na.omit
#'@importFrom methods is
model.select <- function(model,keep,sig=0.05,verbose=F){
  # Function Model.select
  # model is the lm object of the full model
  # keep is a list of model terms to keep in the model at all times
  # sig gives the significance for removal of a variable. Can be 0.1 too (see SPSS)
  # verbose=T gives the F-tests, dropped var and resulting model after
  counter=1
  # check input
  if(!is(model,"lm")) stop(paste(deparse(substitute(model)),"is not an lm object\n"))
  # calculate scope for drop1 function
  terms <- attr(model$terms,"term.labels")
  if(missing(keep)){ # set scopevars to all terms
    scopevars <- terms
  } else{            # select the scopevars if keep is used
    index <- match(keep,terms)
    # check if all is specified correctly
    if(sum(is.na(index))>0){
      novar <- keep[is.na(index)]
      warning(paste(
        c(novar,"cannot be found in the model",
          "\nThese terms are ignored in the model selection."),
        collapse=" "))
      index <- as.vector(na.omit(index))
    }
    scopevars <- terms[-index]
  }

  # Backward model selection :

  while(T){
    # extract the test statistics from drop.
    test <- drop1(model, scope=scopevars,test="F")

    if(verbose){
      cat("-------------STEP ",counter,"-------------\n",
          "The drop statistics : \n")
      print(test)
    }

    pval <- test[,dim(test)[2]]

    names(pval) <- rownames(test)
    pval <- sort(pval,decreasing=T)

    if(sum(is.na(pval))>0) stop(paste("Model",
                                      deparse(substitute(model)),"is invalid. Check if all coefficients are estimated."))

    # check if all significant
    if(pval[1]<sig) break # stops the loop if all remaining vars are sign.

    # select var to drop
    i=1
    while(T){
      dropvar <- names(pval)[i]
      check.terms <- terms[-match(dropvar,terms)]
      x <- has.interaction(dropvar,check.terms)
      if(x){i=i+1;next} else {break}
    } # end while(T) drop var

    if(pval[i]<sig) break # stops the loop if var to remove is significant

    if(verbose){
      cat("\n--------\nTerm dropped in step",counter,":",dropvar,"\n--------\n\n")
    }

    #update terms, scopevars and model
    scopevars <- scopevars[-match(dropvar,scopevars)]
    terms <- terms[-match(dropvar,terms)]

    formul <- as.formula(paste(".~.-",dropvar))
    model <- update(model,formul)

    if(length(scopevars)==0) {
      warning("All variables are thrown out of the model.\n",
              "No model could be specified.")
      return()
    }
    counter=counter+1
  } # end while(T) main loop
  return(model)

  #list(model=model, fm=formul)
}
